package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * 勤策-客户管理-终端
 * @TableName qc_clientele_shop
 */
@TableName(value ="qince_clientele_store")
@Data
public class QinCeClienteleStoreDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 勤策的门店唯一ID
     */
    @JsonProperty("id")
    private String qcId;

    /**
     * 源于第三方系统的门店唯一ID
     */
    @JsonProperty("store_id")
    private String storeId;

    /**
     * 创建人id，来源勤策员工唯一ID
     */
    @JsonProperty("creator_waiqin_id")
    private String creatorWaiqinId;

    /**
     * 创建人名称
     */
    @JsonProperty("creator_name")
    private String creatorName;

    /**
     * 创建人id，来源第三方系统的唯一ID
     */
    @JsonProperty("creator_id")
    private String creatorId;

    /**
     * 退回原因
     */
    @JsonProperty("return_pool_reason")
    private String returnPoolReason;

    /**
     * 门店名称
     */
    @JsonProperty("store_name")
    private String storeName;

    /**
     * 门店编码
     */
    @JsonProperty("store_code")
    private String storeCode;

    /**
     * 门店经理,多门店经理名称间以“,”分隔
     */
    @JsonProperty("store_manager")
    private String storeManager;

    /**
     * 勤策门店经理id。第三方唯一标识，多门店经理id间以“,”分隔
     */
    @JsonProperty("store_manager_id")
    private String storeManagerId;

    /**
     * 勤策门店经理id。勤策唯一标识，多门店经理id间以“,”分隔。store_manager_waiqin365_id、store_manager_id、store_manager如果同时存在，优先级依次降低
     */
    @JsonProperty("store_manager_waiqin365_id")
    private String storeManagerWaiqin365Id;

    /**
     * 门店类型名称
     */
    @JsonProperty("store_type")
    private String storeType;

    /**
     * 门店类型编码
     */
    @JsonProperty("store_type_code")
    private String storeTypeCode;

    /**
     * 门店类型id
     */
    @JsonProperty("store_type_id")
    private String storeTypeId;

    /**
     * 勤策门店等级ID
     */
    @JsonProperty("store_level_id")
    private String storeLevelId;

    /**
     * 门店等级名称
     */
    @JsonProperty("store_level")
    private String storeLevel;

    /**
     * 勤策门店所属部门ID
     */
    @JsonProperty("store_dept_waiqin365_id")
    private String storeDeptWaiqin365Id;

    /**
     * 门店所属部门，来源第三方系统的唯一标识和部门信息中org_id对应
     */
    @JsonProperty("store_dept_id")
    private String storeDeptId;

    /**
     * 门店部门名称
     */
    @JsonProperty("store_dept_name")
    private String storeDeptName;

    /**
     * 门店所属销售区域，此字段为 销售区域的最末级结构
     */
    @JsonProperty("store_district")
    private String storeDistrict;

    /**
     * 门店所属销售区域，此字段为销售区域的完整层级结构，多层级间以“,”分隔。 如：华中大区,南京分区,秦淮社区
     */
    @JsonProperty("store_district_full_path")
    private String storeDistrictFullPath;

    /**
     * 门店所属销售区域ID，来源于勤策的销售区域唯一ID
     */
    @JsonProperty("store_district_waiqin365_id")
    private String storeDistrictWaiqin365Id;

    /**
     * 第三方销售区域id
     */
    @JsonProperty("store_third_district_id")
    private String storeThirdDistrictId;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    @JsonProperty("store_mss_province")
    private String storeMssProvince;

    /**
     * 门店所属行政区域-省份编码，如：110000、320000
     */
    @JsonProperty("store_mss_province_code")
    private String storeMssProvinceCode;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    @JsonProperty("store_mss_city")
    private String storeMssCity;

    /**
     * 门店所属行政区域-城市编码，如：320100
     */
    @JsonProperty("store_mss_city_code")
    private String storeMssCityCode;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    @JsonProperty("store_mss_area")
    private String storeMssArea;

    /**
     * 门店所属行政区域-区县编码，如：320106
     */
    @JsonProperty("store_mss_area_code")
    private String storeMssAreaCode;

    /**
     * 门店所属行政区域-乡镇街道名称，如：宁海路街道
     */
    @JsonProperty("store_mss_street")
    private String storeMssStreet;

    /**
     * 门店所属行政区域-乡镇街道编码，如：320106001
     */
    @JsonProperty("store_mss_street_code")
    private String storeMssStreetCode;

    /**
     * 门店所在地址
     */
    @JsonProperty("store_addr")
    private String storeAddr;

    /**
     * 勤策合作状态ID
     */
    @JsonProperty("store_cooperate_status_id")
    private String storeCooperateStatusId;

    /**
     * 合作状态编码。0：终止合作，1：合作中，2：未合作，3：有意向
     */
    @JsonProperty("store_cooperate_status")
    private String storeCooperateStatus;

    /**
     * 门店所属连锁品牌
     */
    @JsonProperty("store_ka_sys")
    private String storeKaSys;

    /**
     * 门店电话，如：02544550010或025-44550010
     */
    @JsonProperty("store_tel")
    private String storeTel;

    /**
     * 门店传真，如：02544550010或025-44550010
     */
    @JsonProperty("store_fax")
    private String storeFax;

    /**
     * 门店邮编
     */
    @JsonProperty("store_post")
    private String storePost;

    /**
     * 门店备注
     */
    @JsonProperty("store_remarks")
    private String storeRemarks;

    /**
     * 商圈等级
     */
    @JsonProperty("tradingarea_big")
    private String tradingareaBig;

    /**
     * 商圈标签
     */
    @JsonProperty("tradingarea")
    private String tradingarea;

    /**
     * 商圈等级编码
     */
    @JsonProperty("tradingarea_level_code")
    private String tradingareaLevelCode;

    /**
     * 商圈等级名称
     */
    @JsonProperty("tradingarea_level_name")
    private String tradingareaLevelName;

    /**
     * 勤策销售区域id。此字段从2021年8月01日起，对新创建第三方应用不再返回真实store_district_id，使用store_district_waiqin365_id代替store_district_id
     */
    @JsonProperty("store_district_id")
    private String storeDistrictId;

    /**
     * 门店所属销售区域编码，来源于勤策的销售区域编码。
     */
    @JsonProperty("store_district_code")
    private String storeDistrictCode;

    /**
     * 销售区域创建时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_district_create_time")
    private String storeDistrictCreateTime;

    /**
     * 销售区域修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_district_modify_time")
    private String storeDistrictModifyTime;

    /**
     * 销售区域创建人
     */
    @JsonProperty("store_district_creator_name")
    private String storeDistrictCreatorName;

    /**
     * 销售区域修改人
     */
    @JsonProperty("store_district_modifyier_name")
    private String storeDistrictModifyierName;

    /**
     * 销售区域状态。1：正常，0：删除。默认值为1
     */
    @JsonProperty("store_district_status")
    private String storeDistrictStatus;

    /**
     * 勤策客户层级id。“-1”表示是根节点
     */
    @JsonProperty("store_rel_level_id")
    private String storeRelLevelId;

    /**
     * 门店分层标签名称。多分层标签名称以“,”分隔
     */
    @JsonProperty("store_label")
    private String storeLabel;

    /**
     * 门店分层标签id。多分层标签id以“,”分隔
     */
    @JsonProperty("store_label_id")
    private String storeLabelId;

    /**
     * 门店协助员唯一标识。多协助员唯一标识以“,”分隔
     */
    @JsonProperty("store_assistant_id")
    private String storeAssistantId;

    /**
     * 门店协助员名称。多协助员名称以“,”分隔
     */
    @JsonProperty("store_assistant_name")
    private String storeAssistantName;

    /**
     * 门店道路信息
     */
    @JsonProperty("store_road_msg")
    private String storeRoadMsg;

    /**
     * 门店门牌号信息
     */
    @JsonProperty("store_house_number")
    private String storeHouseNumber;

    /**
     * 门店营业执照信息
     */
    @JsonProperty("store_liscence_name")
    private String storeLiscenceName;

    /**
     * 门店工商注册号信息
     */
    @JsonProperty("store_registration_no")
    private String storeRegistrationNo;

    /**
     * 门店注册日期。格式：yyyy-MM-dd
     */
    @JsonProperty("store_registration_date")
    private String storeRegistrationDate;

    /**
     * 门店经营者信息
     */
    @JsonProperty("store_operator")
    private String storeOperator;

    /**
     * 是否直接交易客户。0：是，1：否
     */
    @JsonProperty("store_sale_direct")
    private String storeSaleDirect;

    /**
     * 门店修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_modify_time")
    private String storeModifyTime;

    /**
     * 门店修改人名称
     */
    @JsonProperty("store_modifyier_name")
    private String storeModifyierName;

    /**
     * 新增门店最终审批通过时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_create_approval_time")
    private String storeCreateApprovalTime;

    /**
     * 修改客户审批通过时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_modify_approval_time")
    private String storeModifyApprovalTime;

    /**
     * 创建方式
     */
    @JsonProperty("store_source_type")
    private String storeSourceType;

    /**
     * 门店营业面积
     */
    @JsonProperty("store_selling_area")
    private String storeSellingArea;

    /**
     * 门店收银台个数
     */
    @JsonProperty("store_cashiers_num")
    private String storeCashiersNum;

    /**
     * 门店货架组数
     */
    @JsonProperty("store_shelf_num")
    private String storeShelfNum;

    /**
     * 门店总排面数
     */
    @JsonProperty("store_total_num")
    private String storeTotalNum;

    /**
     * 门店本品排面数
     */
    @JsonProperty("store_self_product_num")
    private String storeSelfProductNum;

    /**
     * 门店营业开始时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_open_time")
    private Date storeOpenTime;

    /**
     * 门店营业结束时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_close_time")
    private Date storeCloseTime;

    /**
     * 门店门头照信息，多个以“,”号隔开
     */
    @JsonProperty("store_pictures")
    private String storePictures;

    /**
     * 门店营业执照信息，多个以“,”号隔开
     */
    @JsonProperty("store_liscence")
    private String storeLiscence;

    /**
     * 门店客户经理编码，即为员工登录账号，多客户经理唯一标识间以英文“,”隔开
     */
    @JsonProperty("store_manager_code")
    private String storeManagerCode;

    /**
     * 创建人编码
     */
    @JsonProperty("store_creator_code")
    private String storeCreatorCode;

    /**
     * 修改人编码，取最新修改记录操作人
     */
    @JsonProperty("store_modifier_code")
    private String storeModifierCode;

    /**
     * 门店审批状态。1：待审批，2：审批打回，3：审批通过
     */
    @JsonProperty("store_approval_status")
    private String storeApprovalStatus;

    /**
     * 经销商名称
     */
    private String dealersName;

    /**
     * 经销商勤策id
     */
    private String waiqin365DealersId;

    @TableField(exist = false)
    @JsonProperty("dealers")
    private List<JSONObject> dealers;

    /**
     * 门店删除状态。0：删除，1：正常
     */
    @JsonProperty("store_status")
    private String storeStatus;

    /**
     * 创建日期。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("create_time")
    private String createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}