package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoCoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-09-02 18
 * @describe :
 */
@Service
public class ActivityPlanInfoCoreServiceImpl implements ActivityPlanInfoCoreService {

    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;
    @Autowired
    private RedisCache redisCache;

    @Override
    public void updateActivityInfo(ActivityPlanInfoVo activityPlanInfoVo) {
        ActivityPlanInfoWrapper wrap = new ActivityPlanInfoWrapper();
        BeanUtils.copyProperties(activityPlanInfoVo, wrap);
        if (Objects.nonNull(activityPlanInfoVo.getActivityPatternId())) {
            wrap.setActivityPattern(redisCache.getHash(RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey(),
                    String.valueOf(activityPlanInfoVo.getActivityPatternId())));
        }
        employeeActivityPlanInfoDao.update(wrap);
    }

    @Override
    public void save(ActivityPlanInfoVo activityPlanInfoVo) {
        EmployeeActivityPlanInfoDto dto = new EmployeeActivityPlanInfoDto();
        BeanUtils.copyProperties(activityPlanInfoVo,dto);
        employeeActivityPlanInfoDao.saveList(Arrays.asList(dto));
    }
}
