package com.wangxiaolu.promotion.controller.activityplanv2;

import cn.hutool.core.collection.CollectionUtil;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.response.ActivityResponse;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import javax.websocket.server.PathParam;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-02-06 16
 * @describe :
 */
@RestController
@RequestMapping("/plan/v2/query")
public class PromPlanQueryController {

    @Autowired
    private PromPlanQueryService promPlanQueryService;
    @Autowired
    private TemporaryActivityClockQueryService temporaryActivityClockQueryService;
    @Autowired
    private TemporaryActivityQueryService temporaryActivityQueryService;
    @Autowired
    private ExaPlanQueryService exaPlanQueryService;

    @PostMapping("/page")
    public R queryPage(@RequestBody PageInfo pageInfo){
        promPlanQueryService.queryPage(pageInfo);
        return R.success(pageInfo);
    }

    /**
     * 根据计划ID查询任务、打卡信息
     */
    @GetMapping("/{id}")
    public R queryPlanById(@PathParam("id") @PathVariable Long id){
        // 查询计划
        ActivityResponse activityResponse = promPlanQueryService.queryPlanById(id);
        // 查询当前计划是否被稽查
        ActivityExamineDto examineDto = exaPlanQueryService.selectByPlanId(id);
        activityResponse.setExamine(examineDto);
        // 查询促销上报任务
        List<TemporaryActivityReportedDto> reportedDtos = temporaryActivityQueryService.findListByPlan(id);
        if (CollectionUtil.isEmpty(reportedDtos)){
            return R.success(activityResponse);
        }

        // 查询促销上报任务中的打卡信息
        List<ActivityResponse.ActivityReported> aas = new ArrayList<>();
        for (TemporaryActivityReportedDto reportedDto : reportedDtos) {
            TemporaryClockWrapper tcw = new TemporaryClockWrapper();
            tcw.setReportedId(reportedDto.getId());
            // 查询打卡信息
            TemporaryClockDto clockDto = temporaryActivityClockQueryService.selectOne(tcw);
            ActivityResponse.ActivityReported aa = new ActivityResponse.ActivityReported(reportedDto,clockDto);
            aas.add(aa);
        }
        activityResponse.setReporteds(aas);
        return R.success(activityResponse);
    }
}
