package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-18 10
 * @describe :
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityReportedDto {
    /**
     * temporary_activity_reported主键id
     */
    private Long id;

    /**
     * 关联—temporary_info表id
     */
    private Long temporaryId;

    /**
     * 关联—temporary_info表name
     */
    private String temporaryName;

    private String dealerName;
    /**
     * activity_plan_info表id
     */
    private Long planId;
    /**
     * 关联—活动店铺id
     */
    private Long storeId;

    private String lineName;

    /**
     * 关联—活动店铺名称（例：小美超市）
     */
    private String storeName;

    /**
     * 关联—活动店铺地址（例：北京朝阳北路31号1层）
     */
    private String storeAddr;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 活动模式Id
     */
    Integer activityPatternId;

    /**
     * 活动模式
     */
    String activityPattern;

    /**
     * 活动品项：老品/黑鸭/散称
     */
    private String prdClass;
    private String deptQcId;

    private String deptQcOrgName;
//    /**
//     * 关联—审核人员qc_id
//     *
//     */
//    private String approverId;
//
//    /**
//     * 关联—审核人员姓名
//     */
//    private String approveName;
    /**
     * 管理员id
     *
     */
    private Integer manageId;

    /**
     * 管理员姓名
     */
    private String manageName;

    /**
     * 审批状态（审批中、审批通过、退回……）
     */
    private TemActApproveStatus approveStatus;

    private String approveStatusMsg;

    /**
     * 最后一次审批时间
     */
    private Date approveTime;

    /**
     * 退回原因
     */
    private String approveReason;

    /**
     * 推广试吃照片
     */
    List<String> tgscPhotoUrls;
    List<TemporaryActivityPhotoDto> tgscPhotoInfos;
    List<String> tgscChangePhotoUrls;

    /**
     * 推广互动照片
     */
    List<String> tghdPhotoUrls;
    List<TemporaryActivityPhotoDto> tghdPhotoInfos;
    List<String> tghdChangePhotoUrls;

    /**
     * 推广成交照片
     */
    List<String> tgcjPhotoUrls;
    List<TemporaryActivityPhotoDto> tgcjPhotoInfos;
    List<String> tgcjChangePhotoUrls;

    /**
     * POS机页面凭证
     */
    private List<String> psvPhotoUrls;
    private List<TemporaryActivityPhotoDto> psvPhotoInfos;
    private List<String> psvChangePhotoUrls;

    /**
     * 随机任务打卡图片
     */
    private List<TemporaryActivityPhotoDto> randTaskClockPhotoUrls;
    private List<TemporaryActivityPhotoDto> posTaskClockPhotoUrls;

    /**
     * 试吃品照片
     */
    private List<String> scpPhotoUrls;
    /**
     * 配发赠品照片
     */
    private List<String> pfzpPhotoUrls;

    /**
     * 高峰期在岗
     */
    private List<String> gfqPhotoUrls;

    /**
     * 试吃必备物料照片
     */
    private List<String> scbbwlPhotoUrls;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建日期
     */
    private String createDate;

    /**
     * 修改时间
     */
    private Date modifyTime;

    private List<TemporaryActivityMarketCellDto> marketCells;

    /**
     * 任务记录关联打卡id
     */
    private TemporaryClockDto clockDto;

    /**
     * 是否删除
     * 1:有效；0：删除；
     */
    private Integer isDelete;
    // 促销员联系电话
    private String temporaryPhone;
    // 执行方式
    private String executeModePlan;
    // 配发试吃品是否有黑鸭口味
    private String hasBlackDuckFlavor;
    // 配发黑鸭试吃品（根）
    private Integer blackDuckTastingNum;
    // 配发卤香试吃品（根）
    private Integer braisedTastingNum;
    // 配发赠品个数
    private Integer giftNum;
    // 推广活动销额（元）
    private BigDecimal promotionSales;
    // 黑鸭销售（元）
    private BigDecimal blackDuckSales;
    // 礼盒销售（元）
    private BigDecimal giftBoxSales;

    // 手工POS机销额
    private String posManualSalesRecord;
    public void approvedDataVerify(){

    }
}
