package com.wangxiaolu.promotion.domain.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author a02200059
 * @description 针对表【temporary_info】的数据库操作Mapper
 * @createDate 2024-04-09 18:34:54
 * @Entity com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfo
 */
@Mapper
@Repository
public interface TemporaryInfoMapper extends BaseMapper<TemporaryInfoDO> {

    // 根据openId查询非保密数据，保密数据不返回：身份证号、身份证照片等信息
    TemporaryInfoDO getUnimportantData(@Param("openId") String openId);

    @Select({
            "SELECT ti.store_code AS storeCode, ",
            "       ti.store_name AS storeName, ",
            "       api.id AS planId ",
            "FROM temporary_info ti ",
            "LEFT JOIN activity_plan_info api ON ti.store_name = api.store_name ",
            "                               AND api.is_delete = 1 ",
            "                               AND api.`date` = #{date} ",
            "WHERE ti.open_id = #{openId}"
    })
    Map<String, Object> selectStoreAndPlan(
            @Param("openId") String openId,
            @Param("date") String date
    );

    int batchInsertOrUpdate(List<TemporaryInfoDO> doList);
}




