package com.wangxiaolu.promotion.controller.user.tem;

import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.DataUtils;
import com.wangxiaolu.promotion.common.util.EnvUtil;
import com.wangxiaolu.promotion.domain.user.mapper.entity.WxTemporaryInfoDelayDO;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.WxTemporaryInfoDelayDtO;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryEnrollVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-04-03 17
 * @describe : 微信用户信息
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/core")
public class TemporaryInfoCoreController {

    @Autowired
    private WeChatUserCoreService weChatUserCoreService;
    @Autowired
    private WeChatUserQueryService weChatUserQueryService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private EnvUtil envUtil;

    /**
     * 促销员注册信息
     */
    @PostMapping("/temporary/enroll")
    public R enrollUserInfo(@RequestBody @Validated WxTemporaryEnrollVo wxTemporaryEnrollVo) {
        wxTemporaryEnrollVo.validate();
        // 人员信息校验
//        boolean isIden = DataUtils.idenCardPattern(wxTemporaryEnrollVo.getIdenNumber());
//        if (!isIden) {
//            throw new ParamException(RCode.IDEN_NUMBER_PARAM_ERROR, null);
//        }
        if (!DataUtils.phonePattern(wxTemporaryEnrollVo.getPhone())) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }

        /**
         * 手机号-验证码 校验
         */
//        if (envUtil.isLive()) {
//            String redisKey = RedisKeys.UserKeys.PHONE_VER_CODE.getKey() + wxTemporaryEnrollVo.getPhone();
//            String phoneCodeOld = redisCache.get(redisKey);
//            if (StringUtils.isBlan
//            k(phoneCodeOld) || !phoneCodeOld.equals(wxTemporaryEnrollVo.getPhoneCode())) {
//                throw new ParamException(RCode.TENCENT_SMS_PHONE_CODE_ERROR, null);
//            }
//            redisCache.removeKey(redisKey);
//        }

        WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
        BeanUtils.copyProperties(wxTemporaryEnrollVo, temporaryDto);
        return R.success(weChatUserCoreService.saveWxUserInfoTemporary(temporaryDto));
    }

    @PutMapping("/temporary/changeStoreInfo")
    public R changeUserInfo(@RequestBody  WxTemporaryEnrollVo wxTemporaryEnrollVo) {
        if (wxTemporaryEnrollVo.getOpenId() == null) {
            throw new ParamException(RCode.WX_OPENID_PARAM_ERROR, null);
        }
        Map<String, Object> temporaryWorkStore = weChatUserQueryService.findTemporaryWorkStore(wxTemporaryEnrollVo.getOpenId(), LocalDate.now().toString());
        if (temporaryWorkStore.get("storeName") ==  null || temporaryWorkStore.get("storeCode") == null ) {
            WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
            BeanUtils.copyProperties(wxTemporaryEnrollVo, temporaryDto);
            weChatUserCoreService.saveWxUserStoreInfoTemporary(temporaryDto);
        }

        // 转换为延迟表实体
        WxTemporaryInfoDelayDtO delayEntity = new WxTemporaryInfoDelayDtO();
        BeanUtils.copyProperties(wxTemporaryEnrollVo, delayEntity);
        // 设置数据日期（当天）、创建时间、未处理状态
        delayEntity.setCreateTime(LocalDateTime.now());
        delayEntity.setIsProcessed(0);

        // 保存到延迟表
        boolean saveResult = weChatUserCoreService.saveDelayData(delayEntity);
        return R.success(saveResult);
    }

}
