package com.wangxiaolu.promotion.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
@Service
public class WeChatUserQueryServiceImpl implements WeChatUserQueryService {

    private static final Logger log = LoggerFactory.getLogger(WeChatUserQueryServiceImpl.class);
    @Autowired
    TemporaryInfoDao temporaryInfoDao;

    @Override
    public boolean loginTemporaryByOpenId(String userOpenId) {
        WxTemporaryInfoDto temDto = temporaryInfoDao.getUnimportantData(userOpenId);
        boolean exist = !Objects.isNull(temDto);

        // todo 查询到时，将个人信息放到reids中进行保存
        if (exist) {
            log.info("微信-促销员{}登录成功，openId：{}", temDto.getName(), userOpenId);
            log.info(JSONObject.toJSONString(temDto));
        } else {
            log.info("微信-促销员登录失败，登录openId：{}", userOpenId);
        }

        return exist;
    }

    /**
     * 根据openId查询人员详情
     * @param openId 微信openId
     * @return 不返回身份证照片等重要信息，详情请查看sql语句
     */
    @Override
    public WxTemporaryInfoDto getTemporaryByOpenId(String openId) {
        // todo 先查询redis中是否有缓存数据

        // todo redis中没有缓存数据，则进行查询
        WxTemporaryInfoDto temporaryInfoDto = temporaryInfoDao.getUnimportantData(openId);
        if (Objects.isNull(temporaryInfoDto)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }

        return temporaryInfoDto;
    }
}
