package com.wangxiaolu.promotion.controller.tengxunyun;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-04-15 11
 * @describe : 对接腾讯云接口
 * 如：腾讯云短信
 */
@Slf4j
@RestController
@RequestMapping("/tencent")
public class TengXunYunController {
    @Value("${tengxunyun.secret_d}")
    private String secretId;
    @Value("${tengxunyun.secret_key}")
    private String secretKey;
    @Value("${tengxunyun.sms.endpoint_beijing}")
    private String endpointBeijing;
    @Value("${tengxunyun.sms.ap_beijing}")
    private String apBeijing;
    @Value("${tengxunyun.sms.sdk_app_id_defult}")
    private String sdkAppIdDefult;
    @Value("${tengxunyun.sms.sign_name}")
    private String signName;
    @Value("${tengxunyun.sms.template_id}")
    private String templateId;
    @Value("${tengxunyun.sms.overdue_long}")
    private String overdueLong;

    /**
     * 腾讯云短信
     */
    @PostMapping("/send/sms")
    public void sendSms(Map<String, String> phoneInfo) {
        String phone = phoneInfo.get("phone");

        if (StringUtils.isEmpty(phone) || !DataUtils.phonePattern(phone)) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }

        // todo 生成6位验证码并且放到redis中
        String phoneVerCode = DataUtils.phoneVerCode();
        System.out.println("生成验证码:" + phoneVerCode);


        try {

            /**
             * 必要步骤
             */
            // 1、实例化一个认证对象
            Credential cred = new Credential(secretId, secretKey);
            // 2、实例化http选项，SDK默认使用POST方法，GET方法无法处理一些较大的请求（非必要不使用）;SDK有默认的超时时间，非必要请不要进行调整
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("POST");
            httpProfile.setConnTimeout(60);
            httpProfile.setEndpoint(endpointBeijing);


            /**
             * 非必要步骤
             */
            // 1、例化一个客户端配置对象
            ClientProfile clientProfile = new ClientProfile();
            /* SDK默认用TC3-HMAC-SHA256进行签名
             * 非必要请不要修改这个字段 */
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            // 实例化sms(服务)的client对象
            SmsClient client = new SmsClient(cred, apBeijing, clientProfile);
            /* 实例化一个请求对象，根据调用的接口和实际情况，可以进一步设置请求参数*/
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppId(sdkAppIdDefult);
            req.setSignName(signName);
            req.setTemplateId(templateId);
            /**
             * 模板参数
             * index0：验证码；index1：过期时间(分钟)
             */
            String[] templateParamSet = {"654321", overdueLong};
            req.setTemplateParamSet(templateParamSet);

            /**
             * 下发手机号码，采用E.164标准(+[国家或地区码][手机号])，最多不要超过200个手机号
             */
            String E164 = "+86";
            String[] phoneNumberSet = {E164 + "15701654502", phoneVerCode};
            req.setPhoneNumberSet(phoneNumberSet);

            /* 用户的 session 内容（无需要可忽略）: 可以携带用户侧 ID 等上下文信息，server 会原样返回 */
            String sessionContext = "";
            req.setSessionContext(sessionContext);
            /* 短信码号扩展号（无需要可忽略）: 默认未开通，如需开通请联系 [腾讯云短信小助手] */
            String extendCode = "";
            req.setExtendCode(extendCode);
            /* 国内短信无需填写该项；国际/港澳台短信已申请独立 SenderId 需要填写该字段，默认使用公共 SenderId，无需填写该字段。注：月度使用量达到指定量级可申请独立 SenderId 使用，详情请联系 [腾讯云短信小助手](https://cloud.tencent.com/document/product/382/3773#.E6.8A.80.E6.9C.AF.E4.BA.A4.E6.B5.81)。*/
            String senderid = "";
            req.setSenderId(senderid);
            /* 通过 client 对象调用 SendSms 方法发起请求。注意请求方法名与请求对象是对应的
             * 返回的 res 是一个 SendSmsResponse 类的实例，与请求对象对应 */
            SendSmsResponse res = client.SendSms(req);

            // 输出json格式的字符串回包，或者取出单个值：System.out.println(res.getRequestId());
            System.out.println(SendSmsResponse.toJsonString(res));

        } catch (TencentCloudSDKException e) {
            log.error("腾讯云-短信服务，SMS发送异常：{}", e.getMessage());
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
    }


}
