package com.wangxiaolu.promotion.xxljobtask;


import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.enums.FlagType;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.enums.activity.ActivityClockTaskStatus;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.TemporaryActivityTaskClockMessageType;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemporaryInfoService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import com.wangxiaolu.promotion.service.activity.temporary.impl.SubscribeMessageService;
import com.wangxiaolu.promotion.websocket.TemporaryActivityTaskClockSocketHandler;
import com.wangxiaolu.promotion.websocket.pojo.MessageBean;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.wangxiaolu.promotion.common.constant.WechatConstants.RANDOM_TASK_URL;
import static com.wangxiaolu.promotion.common.constant.WechatConstants.SUBSCRIBE_MESSAGE_TEMPLATE_ID;

/**
 * @author : liqiulin
 * @date : 2024-09-10 12
 * @describe : 活动类型操作
 */
@Component
@Slf4j
public class ActivityStautsHandler {

    @Autowired
    private TemporaryActivityTaskClockService taskClockService;
    @Autowired
    private SubscribeMessageService messageService;
    @Autowired
    private TemporaryActivityTaskClockSocketHandler taskClockSocketHandler;
    @Autowired
    private EmployeeCoreTemporaryInfoService temporaryInfoService;
    @XxlJob("testSubscribeMessage")
    public void TestSubscribeMessage() {
        List<TemporaryActivityTaskClockDO> list = taskClockService.list(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                 .eq(TemporaryActivityTaskClockDO::getTaskType, ActivityPhotoType.RANDOM_TASK.getType())
                .eq(TemporaryActivityTaskClockDO::getIsDelete, FlagType.NO.getType())
                .le(TemporaryActivityTaskClockDO::getCreateDate, new Date())
         );
        for (TemporaryActivityTaskClockDO taskClockDO : list) {
            sendWebsocketMessage(taskClockDO);
        }

    }
    @XxlJob("sendSubscribeMessage")
    public void sendSubscribeMessage() {
        DateTime undoDateTime = DateUtil.offsetMinute(new Date(), -15);

        // 查询没有做随机任务的， 超过15分钟的，但是状态还是1进行中的  状态改成未完成，表示未拍照做任务
        List<TemporaryActivityTaskClockDO> undoList = taskClockService.list(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                        .eq(TemporaryActivityTaskClockDO::getTaskStatus, ActivityClockTaskStatus.STARTING.getType())
                        .eq(TemporaryActivityTaskClockDO::getTaskType, ActivityPhotoType.RANDOM_TASK.getType())
                        .eq(TemporaryActivityTaskClockDO::getIsDelete, FlagType.NO.getType())
//                        .eq(TemporaryActivityTaskClockDO::getIsSendSubscribe, FlagType.NO.getType())
                        // 小于等于
                        .le(TemporaryActivityTaskClockDO::getRequiredlockTime, undoDateTime));
        for (TemporaryActivityTaskClockDO taskClockDO : undoList){
            taskClockDO.setIsSendSubscribe(FlagType.NO.getType());
            taskClockDO.setTaskStatus(ActivityClockTaskStatus.UNCOMPLETED.getType());
            taskClockService.updateById(taskClockDO);
        }

        // 待开始的 ->进行中
        List<TemporaryActivityTaskClockDO> list = taskClockService.list(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                .eq(TemporaryActivityTaskClockDO::getTaskStatus, ActivityClockTaskStatus.TO_BE_START.getType())
                .eq(TemporaryActivityTaskClockDO::getTaskType, ActivityPhotoType.RANDOM_TASK.getType())
                .eq(TemporaryActivityTaskClockDO::getIsDelete, FlagType.NO.getType())
                .le(TemporaryActivityTaskClockDO::getRequiredlockTime, new Date())
                .ge(TemporaryActivityTaskClockDO::getRequiredlockTime, undoDateTime)
        );

        List<TemporaryActivityTaskClockDO> startingList = taskClockService.list(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                .eq(TemporaryActivityTaskClockDO::getTaskStatus, ActivityClockTaskStatus.STARTING.getType())
                .eq(TemporaryActivityTaskClockDO::getIsSendSubscribe, FlagType.NO.getType())
                .eq(TemporaryActivityTaskClockDO::getTaskType, ActivityPhotoType.RANDOM_TASK.getType())
                .eq(TemporaryActivityTaskClockDO::getIsDelete, FlagType.NO.getType())
                .le(TemporaryActivityTaskClockDO::getRequiredlockTime, new Date())
                .ge(TemporaryActivityTaskClockDO::getRequiredlockTime, undoDateTime)
        );

        list.addAll(startingList);
        for (TemporaryActivityTaskClockDO taskClockDO : list) {
            sendWebsocketMessage(taskClockDO);
            sendWxMessage(taskClockDO);
            //  修改状态 待开始 -> 进行中
            taskClockDO.setTaskStatus(ActivityClockTaskStatus.STARTING.getType());
            taskClockService.updateById(taskClockDO);
        }

    }

    private void sendWebsocketMessage(TemporaryActivityTaskClockDO taskClockDO) {
        // 发送websocket 通知用户
        MessageBean msgBean = new MessageBean();
        msgBean.setMsgType(TemporaryActivityTaskClockMessageType.RANDOM_TASK_START.getType());
        msgBean.setData(taskClockDO);
        Integer successFlag = taskClockSocketHandler.sendToUser(taskClockDO.getTemporaryId().toString(), msgBean);
        if(successFlag == 1){
            log.info("完成发送websocket信息,用户id：{}", taskClockDO.getTemporaryId());
            taskClockDO.setIsSendSubscribe(FlagType.YES.getType());
        }
    }

    /**
     * 发送微信模板消息
     * @param taskClockDO
     */
    private void sendWxMessage(TemporaryActivityTaskClockDO taskClockDO) {
        if(ObjectUtil.isNotEmpty(taskClockDO.getSubscribeTime())){
            // 2. 构建模板数据（根据小程序订阅模板的字段定义）
            Map<String, String> data = new HashMap<>();
            // 模板中的字段1发布人
            data.put("thing2", "小卤促销平台");
            // 模板中的字段2 截止时间
            DateTime requiredlockTime = DateUtil.offsetMinute(taskClockDO.getRequiredlockTime(), 15);
            data.put("time3", DateUtil.format(requiredlockTime,"yyyy-MM-dd HH:mm"));
            // 模板中的字段3 任务名称
            data.put("thing1", "请拍摄清晰的工作场景照片");
            // 模板中的字段4 温馨提示
            data.put("thing4", "请在15分钟内完成任务");

            // 3. 发送通知
            // 获取openid
            WxTemporaryInfoDto wxTemporaryInfoDto = temporaryInfoService.selectById(taskClockDO.getTemporaryId());

            String openid = wxTemporaryInfoDto.getOpenId();
            // 3. 发送通知
            String templateId = SUBSCRIBE_MESSAGE_TEMPLATE_ID;
            boolean success = messageService.sendSubscribeMessage(
                    openid,
                    templateId,
                    // 跳转页面
                    RANDOM_TASK_URL,
                    data
            );
            log.info("促销员微信订阅通知发送结果:{}，openid:{}", success, openid);

            if (success) {
                taskClockDO.setSubscribeTime(new Date());
                taskClockDO.setSubscribeStatus(FlagType.YES.getType());
            }
        }
    }


}
