package com.wangxiaolu.promotion.websocket;

import com.wangxiaolu.promotion.common.util.JwtTokenUtils;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import io.jsonwebtoken.JwtException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


@Slf4j
public class JwtHandshakeInterceptor implements HandshakeInterceptor {

    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response,
                                   WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        // 从请求参数中获取token（前端连接时需携带token参数）
        HttpServletRequest servletRequest = ((ServletServerHttpRequest) request).getServletRequest();
        String token = servletRequest.getParameter("token");
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("Token is required");
        }

        try {
            // 验证token并获取用户ID
//            String userId = JwtUtils.validateToken(token);
            String userId = JwtTokenUtils.getUserId(JwtTokenUtils.parseToken(token));
            // 将用户ID存入属性，供后续WebSocket处理器使用
            attributes.put("userId", userId);
            return true;  // 验证通过，允许握手
        } catch (JwtException e) {
            // 验证失败，拒绝连接
            response.setStatusCode(org.springframework.http.HttpStatus.UNAUTHORIZED);
            return false;
        }
    }

    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response,
                               WebSocketHandler wsHandler, Exception exception) {
        // 握手后操作（可选）
        log.info("Handshake completed");
    }
}
