package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.common.enums.FlagType;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityTaskClockDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryTaskClockDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemClockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-07-18 13
 * @describe :
 */
@Service
@Slf4j
public class EmployeeCoreTemClockServiceImpl implements EmployeeCoreTemClockService {

    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;
    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    private TemporaryActivityPhotoDao temporaryActivityPhotoDao;
    @Autowired
    TemporaryActivityTaskClockDao taskClockDao;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateClockactivityPattern(TemporaryClockDto temporaryClockDto) {
        TemporaryClockDto clockDto = temporaryActivityClockDao.selectById(temporaryClockDto.getId());
        if (Objects.isNull(clockDto)){
           throw new DataException(RCode.DATA_NOT_HAVE_ERROR);
        }

        temporaryActivityClockDao.updateById(temporaryClockDto);

        TemporaryActivityReportedDto reportedDto = new TemporaryActivityReportedDto();
        reportedDto.setId(clockDto.getReportedId())
                .setActivityPatternId(temporaryClockDto.getActivityPatternId())
                .setActivityPattern(temporaryClockDto.getActivityPattern());

        temporaryActivityReportedDao.updateById(reportedDto);
    }

    @Override
    public Long deleteClockById(long id) {
        // 查询打卡记录并删除
        TemporaryClockDto clockDto = temporaryActivityClockDao.selectById(id);
        if (Objects.isNull(clockDto)){
            throw new DataException(RCode.CLOCK_DATA_NOT_HAVE_ERROR);
        }
        return deleteClock(clockDto);
    }

    @Override
    public Long deleteClockByReportedId(long reportedId) {
        // 查询打卡记录并删除
        TemporaryClockWrapper tcw = new TemporaryClockWrapper();
        tcw.setReportedId(reportedId);
        TemporaryClockDto clockDto = temporaryActivityClockDao.selectOne(tcw);
        if (Objects.isNull(clockDto)){
            throw new DataException(RCode.CLOCK_DATA_NOT_HAVE_ERROR);
        }
        return deleteClock(clockDto);
    }

    private Long deleteClock(TemporaryClockDto clockDto){
        TemporaryClockDto updateClockDto = new TemporaryClockDto();
        updateClockDto.setId(clockDto.getId()).setIsDelete(StatusType.INVALID.getType());
        temporaryActivityClockDao.updateById(updateClockDto);

        // 删除打卡记录图片
        TemporaryPhotoWrapper tpw = new TemporaryPhotoWrapper();
        tpw.setTemporaryId(clockDto.getTemporaryId())
                .setClockId(clockDto.getId());
        temporaryActivityPhotoDao.updateStatus(tpw,StatusType.INVALID.getType());

        TemporaryTaskClockDto updateTaskClockDto = new TemporaryTaskClockDto();
        updateTaskClockDto.setClockId(clockDto.getId())
                .setIsDelete(FlagType.YES.getType());
        taskClockDao.updateTaskClock(updateTaskClockDto);
        return clockDto.getPlanId();
    }

}
