package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.common.excel.ReadExcelUtils;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanRecordDao;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordCoreService;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-08-21 13
 * @describe :
 */
@Service
public class ActivityPlanRecordCoreServiceImpl implements ActivityPlanRecordCoreService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EmployeeActivityPlanRecordDao employeeActivityPlanRecordDao;
    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveActivityPlan(EmployeeActivityPlanRecordDto planDto, ActivityPlanVo activityPlanVo) throws Exception {
        // 保存上传记录
        Long planRecordId = employeeActivityPlanRecordDao.save(planDto);
        planDto.setId(planRecordId);
        // 解析excel表是否符合规范、保存
        saveActivityPlanInfo(activityPlanVo, planDto);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteById(Long id) {
        employeeActivityPlanRecordDao.deleteById(id);
        employeeActivityPlanInfoDao.deletebyActivityPlanRecordId(id);
    }

    private void saveActivityPlanInfo(ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 下载
        String filePath = "/home/" + planDto.getExcelFiledId();
        downloadExcel(activityPlanVo.getExcelUrl(), filePath);
        // 读取
        List<EmployeeActivityPlanInfoDto> planInfoDtos = readSheet0(filePath, activityPlanVo, planDto);
        // 保存
        employeeActivityPlanInfoDao.saveList(planInfoDtos);
    }

    private void downloadExcel(String urlStr, String filePath) throws Exception {
        // 保存文件
        URL url = new URL(urlStr);
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
        // 调大小
        byte[] buffer = new byte[102400];
        int bytesRead;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            fileOutputStream.write(buffer, 0, bytesRead);
        }
        fileOutputStream.close();
        inputStream.close();
    }

    private List<EmployeeActivityPlanInfoDto> readSheet0(String filePath, ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 1、解析表格数据
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();
        if (rows.size() <= 0) {
            throw new DataException(RCode.API_DATA_ERROR);
        }

        // 查询当前用户下有效的门店名称列表，用于检查是否存在同名店铺
        Set<String> storeNameDbList = employeeActivityPlanInfoDao.findStoreNameByEmployeeId(activityPlanVo.getEmployeeId());
        Map<Object, Object> dealers = redisCache.getAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey());
        Map<Object, Object> patternMap = redisCache.getAllHash(RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey());
        // 2、校验数据准确性
        verifyRow(rows, dealers,patternMap.values(),storeNameDbList);

        Map<String,Integer> patternInfoMap = new HashMap<>();
        for (Map.Entry<Object, Object> entry : patternMap.entrySet()) {
            patternInfoMap.put(entry.getValue().toString(),Integer.parseInt((String) entry.getKey()));
        }
        /**
         * 3、保存入库
         */
        List<EmployeeActivityPlanInfoDto> planInfoDtos = new ArrayList<>(rows.size() * 2);

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            List<Object> value = entry.getValue();

            EmployeeActivityPlanInfoDto planInfoDto = new EmployeeActivityPlanInfoDto()
                    .setActivityPlanRecordId(planDto.getId())
                    .setExcelFiledId(planDto.getExcelFiledId())
                    .setEmployeeId(activityPlanVo.getEmployeeId())
                    .setEmployeeName(activityPlanVo.getEmployeeName())
                    .setEmployeeNo(activityPlanVo.getEmployeeNo())
                    .setActivityMonth(planDto.getActivityMonth())
                    .setCity((String) value.get(0))
                    .setDealerId((String) value.get(1))
                    .setDealerName((String) dealers.get(value.get(1)))
                    .setLineName((String) value.get(2))
                    .setStoreName((String) value.get(3))
                    .setActivityPattern((String) value.get(4));

            planInfoDto.setActivityPatternId(patternInfoMap.get(planInfoDto.getActivityPattern()));

            planInfoDtos.add(planInfoDto);
        }
        return planInfoDtos;
    }

    /**
     * 校验数据是否规范
     */
    private void verifyRow(Map<Integer, List<Object>> rows, Map<Object, Object> dealers,Collection<Object> patterns,Set<String> storeNameDbSet) throws Exception {

        StringBuilder msg = new StringBuilder();
        List<String> storeList = new ArrayList<>(storeNameDbSet);
        boolean patternY = false;

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            Integer rowNo = entry.getKey() + 1;
            List<Object> value = entry.getValue();

            StringBuilder sb = new StringBuilder();
            String city = (String) value.get(0);
            if (StringUtils.isBlank(city)) {
                sb.append("城市不可为空；");
            }else if (!city.contains("市")){
                value.set(0,city+"市");
            }

            if (!dealers.containsKey(((String) value.get(1)).trim())) {
                sb.append("经销商编码错误；");
            }

            if (StringUtils.isBlank((String) value.get(2))) {
                sb.append("系统名称不可为空；");
            }

            String storeName = (String) value.get(3);
            if (StringUtils.isBlank(storeName)) {
                sb.append("店铺名称不可为空；");
            } else if (storeList.contains(storeName)) {
                sb.append("店铺名称已存在；");
            } else {
                storeList.add(storeName);
            }

            String pattern = (String) value.get(4);
            if (StringUtils.isBlank(pattern)) {
                sb.append("活动模式不可为空；");
            }else if (!patterns.contains(pattern)){
                patternY = true;
            }

            if (sb.length() > 0) {
                msg.append("第").append(rowNo).append("行：").append(sb);
            }

        }

        if (patternY){
            msg.append("活动模式列仅限：").append(patterns).append("（需区分大小写）");
        }
        if (msg.length() > 0) {
            throw new DataException(msg.toString());
        }

    }
}
