package com.wangxiaolu.promotion.domain.manage.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName employee_activity_plan_info
 */
@TableName(value ="employee_activity_plan_info")
@Data
public class EmployeeActivityPlanInfoDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 活动计划表上传记录id
     */
    private Long activityPlanRecordId;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * manage_employee_info表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 活动月份YYYY-MM
     */
//    private String activityMonth;

    /**
     * 城市
     */
    private String city;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 活动模式
     */
    private Integer activityPatternId;
    private String activityPattern;

    private Date createTime;

    private Date modifyTime;

    /**
     * 1:open
     * 0:close
     */
    private Integer activityStatus;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}