package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityClockDaoImpl implements TemporaryActivityClockDao {
    @Autowired
    TemporaryActivityClockMapper temporaryActivityClockMapper;

    @Override
    public void save(TemporaryClockDto dto) {
        // 避免重复打卡
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(dto.getTemporaryId())
                .setCreateDate(DateUtil.today());
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        Integer count = temporaryActivityClockMapper.selectCount(qw);
        if (count > 0) {
            return;
        }

        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        clockDo.setCreateDate(DateUtil.today());
        temporaryActivityClockMapper.insert(clockDo);
        dto.setId(clockDo.getId());
    }

    @Override
    public void updateById(TemporaryClockDto dto) {
        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        temporaryActivityClockMapper.updateById(clockDo);
    }

    /**
     * @param tcw 查询条件
     * @return 上述条件只能满足一条记录
     */
    @Override
    public TemporaryClockDto selectOne(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        TemporaryActivityClockDO clockDO = temporaryActivityClockMapper.selectOne(qw);
        return transitionDto(clockDO);
    }

    private LambdaQueryWrapper<TemporaryActivityClockDO> buildWrapper(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(tcw.getId())) {
            qw.eq(TemporaryActivityClockDO::getId, tcw.getId());
            return qw;
        }

        if (Objects.nonNull(tcw.getTemporaryId())) {
            qw.eq(TemporaryActivityClockDO::getTemporaryId, tcw.getTemporaryId());
        }

        if (StringUtils.isNotBlank(tcw.getCreateDate())) {
            qw.eq(TemporaryActivityClockDO::getCreateDate, tcw.getCreateDate());
        }
        return qw;
    }

    private TemporaryClockDto transitionDto(TemporaryActivityClockDO clockDO) {
        TemporaryClockDto dto = null;
        if (Objects.isNull(clockDO)) {
            return dto;
        }
        dto = new TemporaryClockDto();
        BeanUtils.copyProperties(clockDO, dto);
        return dto;
    }
}
