package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe : 促销员活动上报数据查询
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/query")
public class TemporaryActivityQueryController {

    @Autowired
    TemporaryActivityQueryService temporaryActivityQueryService;

    /**
     * 根据促销员id查询所有任务
     *
     * @return 所有任务（分页查询）
     */
    @PostMapping("/all/{id}")
    public R findtemporaryIdActivityDataList(@PathVariable("id") @NotNull Integer temporaryId, @RequestBody PageInfo pageInfo) {
        temporaryActivityQueryService.findtemporaryIdActivityDataList(temporaryId, pageInfo);
        return R.success(pageInfo);
    }

    /**
     * 根据促销员id查询今日任务
     */
    @GetMapping("/today/{id}")
    public R findTemporaryTodayActivityData(@PathVariable("id") @NotNull Integer temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findtemporaryIdTodayActivityData(temporaryId);
        return R.success(dto);
    }

    /**
     * 根据任务id查询
     */
    @GetMapping("/{id}")
    public R findTemporaryActivityById(@PathVariable("id") @NotNull Long activityId) {
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findTemporaryActivityById(activityId);
        return R.success(dto);
    }
}
