package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityMarketCellDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryMarketCellWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityMarketCellDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeQueryTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-05-30 11
 * @describe : 员工查询促销员活动上报信息
 */
@Service
@Slf4j
public class EmployeeQueryTemActivityServiceImpl implements EmployeeQueryTemActivityService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    TemporaryActivityMarketCellDao temporaryActivityMarketCellDao;
    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;

    /**
     *  tw.setApproverId(employeeQcId)
     */
    @Override
    public void getEmployeeApproveActivityPage(String employeeQcId, PageInfo pageInfo) {
        TemporaryActivityWrapper tw = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryActivityWrapper.class);
        tw = Objects.isNull(tw) ? new TemporaryActivityWrapper() : tw;
        if (TemActApproveStatus.ALL.name().equals(tw.getApproveStatus())){
            tw.setApproveStatus(null);
        }
        temporaryActivityReportedDao.findPage(tw, pageInfo);

        // 查询活动记录关联的售卖单元列表（一次性查出）
        if (CollectionUtils.isEmpty(pageInfo.getRecords())) {
            return;
        }

        List<TemporaryActivityReportedDto> records = pageInfo.getRecords();
        List<Long> activityIds = records.stream().map(TemporaryActivityReportedDto::getId).collect(Collectors.toList());

        // 查询打卡信息
        repClockInfo(activityIds,records);

        // 查询售卖商品信息
//        repMarketCell(activityIds,records);
    }

    /**
     * 补充打卡信息
     */
    private void repClockInfo(List<Long> activityIds,List<TemporaryActivityReportedDto> records) {
        TemporaryClockWrapper tcw = new TemporaryClockWrapper().setReportedIds(activityIds);
        List<TemporaryClockDto> temporaryClockDtos = temporaryActivityClockDao.selectList(tcw);
        Map<Long, List<TemporaryClockDto>> clockDtos = temporaryClockDtos.stream().collect(Collectors.groupingBy(TemporaryClockDto::getReportedId));
        records.stream().forEach(record -> {
            record.setClockDto(clockDtos.get(record.getId()).get(0));
        });
    }

    /**
     * 补充售卖商品信息
     */
    private void repMarketCell(List<Long> activityIds,List<TemporaryActivityReportedDto> records){
        TemporaryMarketCellWrapper mcw = new TemporaryMarketCellWrapper().setActivityIds(activityIds);
        List<TemporaryActivityMarketCellDto> marketCellAll = temporaryActivityMarketCellDao.selectList(mcw);

        if (CollectionUtils.isEmpty(marketCellAll)) {
            return;
        }

        Map<Long, List<TemporaryActivityMarketCellDto>> marketCellGroup = marketCellAll.stream().collect(Collectors.groupingBy(TemporaryActivityMarketCellDto::getActivityReportedId));
        records.stream().forEach( record -> {
            record.setMarketCells(marketCellGroup.get(record.getId()));
        });
    }


}
