package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 促销店铺数据
 * @TableName promotion_store
 */
@TableName(value ="promotion_store")
@Data
@Accessors(chain = true)
public class PromotionStoreDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * qc_id
     */
    private String qcId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺照片
     */
    private String storePhotoUrl;

    /**
     * 系统战区名称
     */
    private String lineOrgName;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 店铺经纬度
     */
    private String coordinates;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    private String province;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    private String city;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    private String area;

    /**
     * 门店所属行政区域-乡镇街道名称，如：宁海路街道
     */
    private String street;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 门店提交人id
     */
    private Integer temporaryId;

    /**
     * 门店提交人
     */
    private String temporaryName;

    /**
     * 所属战区id
     */
    private String deptQcId;

    /**
     * 所属战区名称
     */
    private String deptQcOrgName;

    /**
     * 负责人-勤策ID
     */
    private String chargerQcId;

    /**
     * 负责人姓名
     */
    private String chargerName;

    /**
     * 门店经理
     */
    private String storeManager;

    /**
     * 门店经理勤策id
     */
    private String storeManagerWaiqin365Id;

    /**
     * 经销商名称
     */
    private String dealersName;

    /**
     * 经销商勤策id
     */
    private String waiqin365DealersId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}