package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityQueryServiceImpl implements TemporaryActivityQueryService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Autowired
    TemporaryActivityPhotoDao temporaryActivityPhotoDao;

    /**
     * 根据促销员id查询所有任务
     */
    @Override
    public void findtemporaryIdActivityDataList(Integer temporaryId, PageInfo pageInfo) {
        temporaryActivityReportedDao.findListByTemporaryId(temporaryId, pageInfo);
    }


    /**
     * 根据促销员id查询今日任务
     */
    @Override
    public TemporaryActivityReportedDto findtemporaryIdTodayActivityData(Integer temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findOneByCurrentDate(temporaryId);
        findActivityReportedPhoto(dto);
        return dto;
    }

    @Override
    public TemporaryActivityReportedDto findTemporaryActivityById(Long activityId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findOneById(activityId);
        findActivityReportedPhoto(dto);
        return dto;
    }

    private void findActivityReportedPhoto(TemporaryActivityReportedDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        Map<Integer, List<String>> reportedGroup = temporaryActivityPhotoDao.findReportedGroup(dto.getTemporaryId(), dto.getId());
        if (!CollectionUtils.isEmpty(reportedGroup)) {
            dto.setTgscPhotoUrls(reportedGroup.get(ActivityPhotoType.TGSC.getType()));
            dto.setTghdPhotoUrls(reportedGroup.get(ActivityPhotoType.TGHD.getType()));
            dto.setTgcjPhotoUrls(reportedGroup.get(ActivityPhotoType.TGCJ.getType()));
            dto.setPsvPhotoUrls(reportedGroup.get(ActivityPhotoType.POS_SELL_VOUCHER.getType()));
        }
    }
}
