package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityLogDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.enums.activity.LogType;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.employee.vo.ApproveVO;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeCoreTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-03 14
 * @describe :
 */
@Slf4j
@Service
public class EmployeeCoreTemActivityServiceImpl implements EmployeeCoreTemActivityService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    private TemporaryActivityLogDao tempActivityLogDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void approveActivity(long reportedId, ApproveVO approveVO) {
        TemporaryActivityReportedDto reportedDto = temporaryActivityReportedDao.findOneById(reportedId);
        if (Objects.isNull(reportedDto)) {
            throw new ParamException(RCode.DATA_NOT_HAVE_ERROR, null);
        }

        if (reportedDto.getApproveStatus().equals(approveVO.getApproveStatus())) {
            throw new ParamException(RCode.APPROVE_STATUS_REPETITION, null);
        }

        TemporaryActivityReportedDto temActDto = new TemporaryActivityReportedDto()
                .setId(reportedId)
                .setApproveStatus(approveVO.getApproveStatus())
                .setApproveTime(new Date())
                .setApproveReason(approveVO.getApproveReason());

        temporaryActivityReportedDao.updateById(temActDto);

        // 写日志
        LogType logType = TemActApproveStatus.APPROVED.equals(approveVO.getApproveStatus()) ? LogType.t_5 : LogType.t_4;
        tempActivityLogDao.save(reportedDto.getTemporaryId(), reportedDto.getTemporaryName(), logType, temActDto.getId(), temActDto);
    }
}
