package com.wangxiaolu.promotion.pojo.user.vo;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author : liqiulin
 * @date : 2024-04-08 12
 * @describe : 微信-促销员注册参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class WxTemporaryEnrollVo {
    /**
     * openId
     */
//    @NotBlank(message = "微信登录错误")
    String openId;


    /**
     * 头像
     */
//    @NotBlank(message = "请上传头像")
    String avatarUrl;

    /**
     * 姓名
     */
//    @NotBlank(message = "姓名不可为空")
    String name;

    /**
     * 手机号
     */
//    @NotBlank(message = "手机号不可为空")
    String phone;

    /**
     * 身份证号
     */
//    @NotBlank(message = "身份证号不可为空")
    String idenNumber;

    /**
     * 身份证正面照
     */
//    @NotBlank(message = "请上传身份证正面照")
    String idenFrontPhotoUrl;

    /**
     * 身份证反面照
     */
//    @NotBlank(message = "请上传身份证反面照")
    String idenReversePhotoUrl;

    /**
     * 所属战区-部门
     */
    String deptQcId;

    /**
     * 所属战区-部门
     */
    String deptQcOrgName;

    /**
     * 手机验证码
     */
    String phoneCode;


    /**
     * 此促销员的任务人-勤策id
     */
    String chargerQcId;

    /**
     * 此促销员的任务人姓名
     */
    String chargerName;

    public void validate() {
        if (StringUtils.isBlank(openId)) {
            throw new ParamException(RCode.WX_OPENID_PARAM_ERROR, null);
        }

        if (StringUtils.isBlank(avatarUrl)) {
            throw new ParamException(RCode.NOT_AVATAR_URL_PARAM_ERROR, null);
        }

        if (StringUtils.isBlank(name)) {
            throw new ParamException(RCode.NOT_USER_NAME_PARAM_ERROR, null);
        }

        if (StringUtils.isBlank(phone)) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }

        if (StringUtils.isBlank(phoneCode)) {
            throw new ParamException(RCode.TENCENT_SMS_PHONE_CODE_ERROR, null);
        }

//        if (StringUtils.isBlank(idenNumber)) {
//            throw new ParamException(RCode.IDEN_NUMBER_PARAM_ERROR, null);
//        }
//        if (StringUtils.isBlank(deptQcOrgName)
//                || StringUtils.isBlank(chargerName)
//                || StringUtils.isBlank(deptQcId)
//                || StringUtils.isBlank(chargerQcId)) {
//            throw new ParamException(RCode.CHARGER_ID_ERROR, null);
//        }
    }

}
