package com.wangxiaolu.promotion.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-04-23 15
 * @describe : 时间工具类
 */
public class DateUtils {
    /**
     * 判断时间是否是范围内
     * 入参时间格式："00:00:00"
     */
    public static boolean parseTime(Date date, String beginTime, String endTime) {
        try {
            String today = DateUtil.today();
            String format = DatePattern.NORM_DATETIME_PATTERN;
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date beginTimeD = sdf.parse(today + " " + beginTime);
            Date endTimeD = sdf.parse(today + " " + endTime);
            return DateUtil.isIn(date, beginTimeD, endTimeD);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}
