package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author : liqiulin
 * @date : 2024-04-23 18
 * @describe : 打卡信息查询
 */
@Slf4j
@RestController
@RequestMapping("/temporary/clock/query")
public class TemporaryActivityClockQueryController {

    @Autowired
    TemporaryActivityClockQueryService temporaryActivityClockQueryService;


    /**
     * 根据促销员id查询今日打卡信息
     */
    @GetMapping("/{temporary_id}")
    public R findTodayTemporaryClockByTemId(@PathVariable("temporary_id") @NotNull Integer temporaryId) {
        TemporaryClockDto clockDto = temporaryActivityClockQueryService.findTodayTemporaryClockByTemId(temporaryId);
        return R.success(clockDto);
    }

    /**
     * 根据促销员id查询指定日期打卡信息
     *
     * @param temporaryId 促销员id
     * @param createDate  指定日期，格式：2024-04-25
     * @return 打卡信息
     */
    @GetMapping("/date")
    public R findTemporaryClockByTemIdAndDate(Integer temporaryId, String createDate) {
        TemporaryClockDto clockDto = temporaryActivityClockQueryService.findTemporaryClockByTemIdAndDate(temporaryId, createDate);
        return R.success(clockDto);
    }
}
