package com.wangxiaolu.promotion.controller.user.qince;

import com.wangxiaolu.promotion.pojo.user.dto.QinCeDepartmentDto;
import com.wangxiaolu.promotion.pojo.user.vo.QinceEmployeeQueryVo;
import com.wangxiaolu.promotion.pojo.user.vo.QinceOrgQueryVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.QinCeDepartmentQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-17 13
 * @describe : 勤策部门查询
 */

@RestController
@RequestMapping("/user/dept/query")
public class QinCeDepartmentQueryController {

    @Autowired
    QinCeDepartmentQueryService qinCeDepartmentQueryService;

    /**
     * 查询部门列表
     * 注册促销员、后台页面查询战区列表时使用
     */
    @PostMapping("/enroll/list")
    public R getDeptList(@RequestBody QinceOrgQueryVo qinceOrgQueryVo){
        List<QinCeDepartmentDto> deptDto = qinCeDepartmentQueryService.getDeptList(qinceOrgQueryVo);
        return R.success(deptDto);
    }

}
