package com.wangxiaolu.promotion.xxljobtask;

import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *
 * 开发步骤：
 *      1、任务开发：在Spring Bean实例中，开发Job方法；
 *      2、注解配置：为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 *      3、执行日志：需要通过 "XxlJobHelper.log" 打印执行日志；
 *      4、任务结果：默认任务结果为 "成功" 状态，不需要主动设置；如有诉求，比如设置任务结果为失败，可以通过 "XxlJobHelper.handleFail/handleSuccess" 自主设置任务结果；
 *
 * @author xuxueli 2019-12-11 21:52:51
 */
@Component
@Slf4j
public class XxlJobHandler {

    @Autowired
    QinCeDataTaskService qinCeDataTaskService;


    /**
     * 同步组织架构/部门数据
     */
    @XxlJob("qince_department_task")
    public void departmentSyncTask(){
        log.info("[xxl-job] start === 同步勤策部门数据");
        qinCeDataTaskService.departmentSyncTask();
        log.info("[xxl-job] end === 同步勤策部门数据");
    }

    /**
     * 同步员工数据
     */
    @XxlJob("qince_employee_task")
    public void employeeSyncTask(){
        log.info("[xxl-job] start === 同步员工数据");
        qinCeDataTaskService.employeeSyncTask();
        log.info("[xxl-job] end === 同步员工数据");
    }

    /**
     * 同步[终端数据]
     */
    @XxlJob("qince_shop_task")
    public void shopDetailAllTask(){
        log.info("[xxl-job] start === 同步终端数据");
        qinCeDataTaskService.shopDetailAllTask();
        log.info("[xxl-job] end === 同步终端数据");
    }

}
