package com.wangxiaolu.promotion.service.activity.temporary;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityMarketCellVo;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
public interface TemporaryActivityCoreService {

    /**
     * 活动上报保存
     */
    long activityDataReportedSave(TemporaryActivityReportedDto temActDto);

    /**
     * 活动上报数据修改
     */
    void activityDataReportedUpdate(TemporaryActivityReportedDto temActDto);

    /**
     * 促销员当日打卡信息保存
     */
    void clockInTodayActivity(TemporaryClockDto dto, Integer clockType);

    /**
     * 活动上报数据修改审批状态
     */
    void activityReportedSubmit(Long id);

    /**
     * 根据店铺或打卡记录中的店铺，判断打卡距离
     *
     * @param storeQcId 店铺-勤策-id
     * @param id        打卡记录id
     * @param clockCoordinates 打卡经纬度
     */
    void clockStoreCalDistance(String storeQcId, Long id, String clockCoordinates);

    /**
     * 保存销售上报-出售单元 - 缓存
     */
    void todayActivityMarketCellReported(TemporaryActivityMarketCellVo marketcellVo);

    /**
     * 删除销售上报-出售单元 - 缓存
     */
    void todayActivityDeleteMarketCellReported(Integer temporaryId);

    /**
     * 修改/删除 单一出售单元
     */
    void todayUpdateMarketCellOne(TemporaryActivityMarketCellVo marketcellVo);
}
