package com.wangxiaolu.promotion.controller.user.qince;

import com.wangxiaolu.promotion.pojo.CascadeVo;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductTypeDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.QinCeProductQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-19 17
 * @describe :
 */
@RestController
@RequestMapping("/user/qince/query")
public class QinCeProductQueryController {

    @Autowired
    QinCeProductQueryService qinCeProductQueryService;

    @PostMapping("/product/type/list")
    public R findProductTypeList(){
        List<QinceProductTypeDto> dtos = qinCeProductQueryService.findProductTypeList();
        return R.success(dtos);
    }

    /**
     * 级联选择
     * @return
     */
    @PostMapping("/product/cascade")
    public R findProductCascade(){
        List<CascadeVo> dtos = qinCeProductQueryService.findProductCascade();
        return R.success(dtos);
    }
}
