package com.wangxiaolu.promotion.controller.activity.employee;

import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.employee.vo.ApproveVO;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeCoreTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-06-03 14
 * @describe : 员工操作审批
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/core")
public class EmployeeCoreTemActivityController {

    @Autowired
    EmployeeCoreTemActivityService employeeCoreTemActivityService;

    /**
     * 员工审批上报活动数据
     */
    @PostMapping("/approve/{id}")
    public R approveActivity(@PathVariable("id") long reportedId,@RequestBody ApproveVO approveVO) {
        if (TemActApproveStatus.SEND_BACK.equals(approveVO.getApproveStatus()) && StringUtils.isBlank(approveVO.getApproveReason())){
            throw new ParamException(RCode.SEND_BACK_REASON_NOT,null);
        }
        employeeCoreTemActivityService.approveActivity(reportedId,approveVO);
        return R.success();
    }


}
