package com.wangxiaolu.promotion.pojo.user.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName qince_product_info
 */
@Data
public class QinceProductInfoDto implements Serializable {
    /**
     * 主键id
     */
    private Integer id;

    /**
     * 商品唯一标识，来源第三方系统的唯一ID（ERP）
     */
    private String prdId;

    /**
     * 勤策商品id
     */
    private String prdWaiqin365Id;

    /**
     * 商品名称
     */
    private String prdName;

    /**
     * 商品类型唯一ID，所属类型
     */
    private String classId;

    /**
     * 商品类型名称
     */
    private String className;

    /**
     * 商品类型全路径
     */
    private String classFullPath;

    /**
     * 单位
     */
    private String prdUnit;

    /**
     * 商品规格
     */
    private String prdSpec;

    /**
     * 商品分类，0：普通商品，1：助销物料，2：包装物，3：兑换物料
     */
    private String classification;

    /**
     * 商品编码
     */
    private String prdCode;

    /**
     * 销售状态。0：停售，1：在售
     */
    private String prdSaleStatus;

    /**
     * 销售状态。0：停售，1：在售
     */
    private String saleStatus;

    /**
     * 删除标志。1：正常，0：删除
     */
    private String status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}