package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinCeClienteleStoreMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinCeClienteleStoreDO;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-22 16
 * @describe :
 */
@Slf4j
@Service
public class QinCeClienteleStoreDaoImpl implements QinCeClienteleStoreDao {

    @Autowired
    QinCeClienteleStoreMapper qinCeClienteleStoreMapper;

    /**
     * 拉取信息
     *
     * @param responseDatas 信息json格式数据
     */
    @Override
    public void shopDetailAllTask(JSONArray responseDatas) {
        LambdaQueryWrapper<QinCeClienteleStoreDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            try {
                QinCeClienteleStoreDO qinCeShopDO = JSONObject.parseObject(responseData.toString(), QinCeClienteleStoreDO.class);

                // 添加经销商
                List<JSONObject> dealers = qinCeShopDO.getDealers();
                if (!CollectionUtils.isEmpty(dealers)){
                    qinCeShopDO.setDealersName(dealers.get(0).getString("dealer_name"));
                    qinCeShopDO.setWaiqin365DealersId(dealers.get(0).getString("waiqin365_dealer_id"));
                }

                qw.eq(QinCeClienteleStoreDO::getQcId, qinCeShopDO.getQcId());
                QinCeClienteleStoreDO doExist = qinCeClienteleStoreMapper.selectOne(qw);

                if (Objects.isNull(doExist)) {
                    qinCeClienteleStoreMapper.insert(qinCeShopDO);
                } else {
                    qinCeShopDO.setId(doExist.getId());
                    qinCeClienteleStoreMapper.updateById(qinCeShopDO);
                }
            } catch (Exception e) {
                log.error("勤策-同步终端store数据异常，异常数据：{}", responseData);
                log.error("勤策-同步终端store数据异常\n{}", e.getMessage());
            }
        }


    }

    /**
     * 查询门店列表
     *
     * @param storeWrapper 查询条件
     */
    @Override
    public List<QinCeClienteleStoreDto> getStoreList(StoreWrapper storeWrapper) {
        LambdaQueryWrapper<QinCeClienteleStoreDO> qw = builderQueryWrapper(storeWrapper);
        // 指定字段查询
        qw.select(QinCeClienteleStoreDO::getQcId,
                        QinCeClienteleStoreDO::getStoreName,
                        QinCeClienteleStoreDO::getStoreAddr)
                .last(" limit 100");

        List<QinCeClienteleStoreDO> qinCeClienteleStoreDOS = qinCeClienteleStoreMapper.selectList(qw);
        List<QinCeClienteleStoreDto> storeDtos = transitionDtos(qinCeClienteleStoreDOS);
        return storeDtos;
    }

    @Override
    public QinCeClienteleStoreDto getOneStore(StoreWrapper storeWrapper) {
        LambdaQueryWrapper<QinCeClienteleStoreDO> qw = builderQueryWrapper(storeWrapper);
        // 指定字段查询
        qw.select(QinCeClienteleStoreDO::getQcId,
                QinCeClienteleStoreDO::getStoreName,
                QinCeClienteleStoreDO::getStoreAddr);

        QinCeClienteleStoreDO qinCeClienteleStoreDO = qinCeClienteleStoreMapper.selectOne(qw);
        return transitionDto(qinCeClienteleStoreDO);
    }

    private LambdaQueryWrapper<QinCeClienteleStoreDO> builderQueryWrapper(StoreWrapper storeWrapper) {
        LambdaQueryWrapper<QinCeClienteleStoreDO> qw = new LambdaQueryWrapper<>();
        // 默认查询有效数据 >>> 门店删除状态。0：删除，1：正常：store_status = 1
        qw.eq(QinCeClienteleStoreDO::getStoreStatus, storeWrapper.getStoreStatus());
        // 默认查询有效数据 >>> 门店审批状态。1：待审批，2：审批打回，3：审批通过：store_approval_status = 3
        qw.eq(QinCeClienteleStoreDO::getStoreApprovalStatus, storeWrapper.getStoreApprovalStatus());

        // 按qcId查询
        if (StringUtils.isNotBlank(storeWrapper.getQcId())) {
            qw.eq(QinCeClienteleStoreDO::getQcId, storeWrapper.getQcId());
            return qw;
        }
        // 按终端编码查询
        if (StringUtils.isNotBlank(storeWrapper.getStoreCode())) {
            qw.eq(QinCeClienteleStoreDO::getStoreCode, storeWrapper.getStoreCode());
            return qw;
        }
        // 按门店名称模糊查询
        if (StringUtils.isNotBlank(storeWrapper.getStoreNameVague())) {
            qw.like(QinCeClienteleStoreDO::getStoreName, storeWrapper.getStoreNameVague().trim());
        }
        return qw;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param storeDO DO对象
     * @return DTO对象
     */
    private QinCeClienteleStoreDto transitionDto(QinCeClienteleStoreDO storeDO) {
        QinCeClienteleStoreDto storedDto = null;
        if (!Objects.isNull(storeDO)) {
            storedDto = new QinCeClienteleStoreDto();
            BeanUtils.copyProperties(storeDO, storedDto);
        }
        return storedDto;
    }

    private List<QinCeClienteleStoreDto> transitionDtos(List<QinCeClienteleStoreDO> storeDOs) {
        if (CollectionUtils.isEmpty(storeDOs)) {
            return new ArrayList<>();
        }

        List<QinCeClienteleStoreDto> dtos = new ArrayList<>(storeDOs.size() * 2);
        for (QinCeClienteleStoreDO storeDO : storeDOs) {
            QinCeClienteleStoreDto storeDto = transitionDto(storeDO);
            dtos.add(storeDto);
        }

        return dtos;
    }


}
