package com.wangxiaolu.promotion.controller.user;

import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.pojo.user.vo.ClienteleStoreQueryVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.QinCeClienteleDataQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-22 17
 * @describe : 【勤策 - 客户数据】查询
 */
@RestController
@RequestMapping("/user/clientele/query")
public class QinCeClienteleDataQueryController {

    @Autowired
    QinCeClienteleDataQueryService qinCeClienteleDataQueryService;

    /**
     * 【勤策 - 客户数据 - 终端】数据查询
     * 模糊查询门店名称
     */
    @PostMapping("/store/list")
    public R getStoreList(@RequestBody ClienteleStoreQueryVo storeQueryVo) {
        return R.success(qinCeClienteleDataQueryService.getStoreList(storeQueryVo));
    }


}
