package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.util.MD5Utils;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionManageEmployeeDao;
import com.wangxiaolu.promotion.domain.activity.mapper.PromotionManageEmployeeMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.PromotionManageEmployeeDO;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.PromotionManageEmployeeDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
public class PromotionManageEmployeeDaoImpl implements PromotionManageEmployeeDao {

    @Autowired
    PromotionManageEmployeeMapper promotionManageEmployeeMapper;

    @Override
    public PromotionManageEmployeeDto loginByEmployeeNo(String employeeNo, String pwd) {
        LambdaQueryWrapper<PromotionManageEmployeeDO> lqw = new LambdaQueryWrapper();
        lqw.eq(PromotionManageEmployeeDO::getEmployeeNo,employeeNo);

        PromotionManageEmployeeDO promotionManageEmployeeDO = promotionManageEmployeeMapper.selectOne(lqw);

        if (Objects.isNull(promotionManageEmployeeDO)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
        if (!MD5Utils.getSaltverifyMD5(pwd,promotionManageEmployeeDO.getPasswork())){
            throw new ParamException(RCode.LOGIN_PASSWORD_ERROR,null);
        }

        return transitionDto(promotionManageEmployeeDO);
    }

    @Override
    public PromotionManageEmployeeDto selectById(Integer employeeId) {
        return transitionDto(promotionManageEmployeeMapper.selectById(employeeId));
    }

    private PromotionManageEmployeeDto transitionDto(PromotionManageEmployeeDO employeeDO) {
        PromotionManageEmployeeDto dto = null;
        if (Objects.isNull(employeeDO)) {
            return dto;
        }
        dto = new PromotionManageEmployeeDto();
        BeanUtils.copyProperties(employeeDO, dto);
        return dto;
    }


}
