package com.wangxiaolu.promotion.controller.activity.manage.activityplan;

import com.wangxiaolu.promotion.common.util.NumberUtils;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-09-02 18
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/plan_info/core")
public class ActivityPlanInfoCoreController {

    @Autowired
    ActivityPlanInfoCoreService activityPlanInfoCoreService;

    @PutMapping("/update")
    public R updateActivityInfo(@RequestBody ActivityPlanInfoVo activityPlanInfoVo){
        if (NumberUtils.isNull(activityPlanInfoVo.getId()) && CollectionUtils.isEmpty(activityPlanInfoVo.getIds())){
            throw new DataException(RCode.SELECT_PARAMS_ERROR);
        }
        activityPlanInfoCoreService.updateActivityInfo(activityPlanInfoVo);
        return R.success();
    }
}
