package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeQueryTemClockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-06-03 16
 * @describe :
 */
@Service
@Slf4j
public class EmployeeQueryTemClockServiceImpl implements EmployeeQueryTemClockService {

    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;
    @Autowired
    TemporaryActivityPhotoDao temporaryActivityPhotoDao;

    @Override
    public void findClockList(String employeeQcId, PageInfo pageInfo) {
        TemporaryClockWrapper tcw = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryClockWrapper.class);
        temporaryActivityClockDao.employeePage(employeeQcId,pageInfo,tcw);

        List<TemporaryClockDto> records = pageInfo.getRecords();
        if (CollectionUtils.isEmpty(records)){
            return;
        }
        List<Long> clockIds = records.stream().map(TemporaryClockDto::getId).collect(Collectors.toList());
        Map<Long, Map<Integer, String>> clockPhotoGroupByClockIds = temporaryActivityPhotoDao.findClockPhotoGroupByClockIds(clockIds);

        for (TemporaryClockDto clockDto : records) {
            Map<Integer, String> photoMap = clockPhotoGroupByClockIds.get(clockDto.getId());
            if (CollectionUtils.isEmpty(photoMap)){
                continue;
            }
            clockDto.setClockInPhoto(photoMap.get(ActivityPhotoType.CLOCK_IN.getType()));
            clockDto.setNoonClockOutPhoto(photoMap.get(ActivityPhotoType.NOON_CLOCK_OUT.getType()));
            clockDto.setNoonClockInPhoto(photoMap.get(ActivityPhotoType.NOON_CLOCK_IN.getType()));
            clockDto.setClockOutPhoto(photoMap.get(ActivityPhotoType.CLOCK_OUT.getType()));
        }
    }
}
