package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanRecordDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanRecordWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-08-21 14
 * @describe :
 */
@Service
public class ActivityPlanRecordQueryServiceImpl implements ActivityPlanRecordQueryService {

    @Autowired
    EmployeeActivityPlanRecordDao employeeActivityPlanRecordDao;

    @Override
    public void findActivityPlanRecordPage(PageInfo pageInfo) {
        ActivityPlanRecordWrapper wrap = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), ActivityPlanRecordWrapper.class);
        employeeActivityPlanRecordDao.selectPage(wrap,pageInfo);
    }

    @Override
    public EmployeeActivityPlanRecordDto findActivityPlanRecord(ActivityPlanVo activityPlanVo) {
        ActivityPlanRecordWrapper wp = new ActivityPlanRecordWrapper();
        BeanUtils.copyProperties(activityPlanVo,wp);
        return employeeActivityPlanRecordDao.selectOne(wp);
    }
}
