package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityMarketCellDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityMarketCellMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityMarketCellDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryMarketCellWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityMarketCellDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-21 15
 * @describe :
 */
@Service
public class TemporaryActivityMarketCellDaoImpl implements TemporaryActivityMarketCellDao {

    @Autowired
    TemporaryActivityMarketCellMapper temporaryActivityMarketCellMapper;

    @Override
    public void saveList(Long activityReportedId, JSONArray jsonArray) {
        if (CollectionUtils.isEmpty(jsonArray)) {
            return;
        }

        List<TemporaryActivityMarketCellDO> dos = new ArrayList<>(jsonArray.size() * 2);
        jsonArray.forEach(jri -> {
            JSONObject jo = (JSONObject) jri;
            TemporaryActivityMarketCellDO marketCellDO = JSONObject.parseObject(jo.toString(), TemporaryActivityMarketCellDO.class);
            marketCellDO.setActivityReportedId(activityReportedId);
            marketCellDO.setClassName(jo.getString("prdClassName"));
            marketCellDO.setCreateDate(DateUtil.today());
            dos.add(marketCellDO);
        });
        temporaryActivityMarketCellMapper.saveList(dos);
    }

    @Override
    public List<TemporaryActivityMarketCellDto> selectList(TemporaryMarketCellWrapper wrap) {
        LambdaQueryWrapper<TemporaryActivityMarketCellDO> qw = buildWrapper(wrap);
        qw.select(TemporaryActivityMarketCellDO::getId,
                TemporaryActivityMarketCellDO::getTemporaryId,
                TemporaryActivityMarketCellDO::getActivityReportedId,
                TemporaryActivityMarketCellDO::getClassName,
                TemporaryActivityMarketCellDO::getPrdId,
                TemporaryActivityMarketCellDO::getPrdName,
                TemporaryActivityMarketCellDO::getBag,
                TemporaryActivityMarketCellDO::getBox);

        List<TemporaryActivityMarketCellDO> marketCellDOS = temporaryActivityMarketCellMapper.selectList(qw);
        return transitionDtos(marketCellDOS);
    }

    @Override
    public void updateById(TemporaryActivityMarketCellDto dto) {
        TemporaryActivityMarketCellDO updateDos = new TemporaryActivityMarketCellDO();
        updateDos.setId(dto.getId());
        updateDos.setBox(dto.getBox());
        updateDos.setBag(dto.getBag());
        temporaryActivityMarketCellMapper.updateById(updateDos);
    }

    @Override
    public void deleteById(Long id) {
        TemporaryActivityMarketCellDO updateDos = new TemporaryActivityMarketCellDO();
        updateDos.setId(id);
        updateDos.setIsDelete(StatusType.INVALID.getType());
        temporaryActivityMarketCellMapper.updateById(updateDos);
    }

    @Override
    public void deleteByActivityReportedId(long activityReportedId) {
        LambdaQueryWrapper<TemporaryActivityMarketCellDO> qw = new LambdaQueryWrapper<>();
        qw.eq(TemporaryActivityMarketCellDO::getActivityReportedId,activityReportedId);

        TemporaryActivityMarketCellDO updateDo = new TemporaryActivityMarketCellDO();
        updateDo.setIsDelete(StatusType.INVALID.getType());
        temporaryActivityMarketCellMapper.update(updateDo,qw);
    }

    private LambdaQueryWrapper<TemporaryActivityMarketCellDO> buildWrapper(TemporaryMarketCellWrapper wrap) {

        LambdaQueryWrapper<TemporaryActivityMarketCellDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wrap.getActivityId()) && (wrap.getActivityId() > 0)) {
            qw.eq(TemporaryActivityMarketCellDO::getActivityReportedId, wrap.getActivityId());
        }

        if (Objects.nonNull(wrap.getTemporaryId()) && (wrap.getTemporaryId() > 0)) {
            qw.eq(TemporaryActivityMarketCellDO::getTemporaryId, wrap.getTemporaryId());
        }

        if (!CollectionUtils.isEmpty(wrap.getActivityIds())) {
            qw.in(TemporaryActivityMarketCellDO::getActivityReportedId, wrap.getActivityIds());
        }

        // 默认查询未删除数据
        qw.eq(TemporaryActivityMarketCellDO::getIsDelete, StatusType.VALID.getType());
        return qw;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryActivityMarketCellDto> transitionDtos(List<TemporaryActivityMarketCellDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<TemporaryActivityMarketCellDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryActivityMarketCellDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDo DO对象
     * @return DTO对象
     */
    private TemporaryActivityMarketCellDto transitionDto(TemporaryActivityMarketCellDO temDo) {
        TemporaryActivityMarketCellDto temporaryDto = null;
        if (Objects.isNull(temDo)) {
            return temporaryDto;
        }

        temporaryDto = new TemporaryActivityMarketCellDto();
        BeanUtils.copyProperties(temDo, temporaryDto);
        return temporaryDto;
    }
}
