package com.wangxiaolu.promotion.xxljobtask;

import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *
 * 开发步骤：
 *      1、任务开发：在Spring Bean实例中，开发Job方法；
 *      2、注解配置：为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 *      3、执行日志：需要通过 "XxlJobHelper.log" 打印执行日志；
 *      4、任务结果：默认任务结果为 "成功" 状态，不需要主动设置；如有诉求，比如设置任务结果为失败，可以通过 "XxlJobHelper.handleFail/handleSuccess" 自主设置任务结果；
 *
 * @author xuxueli 2019-12-11 21:52:51
 */
@Component
@Slf4j
public class XxlJobHandler {

    @Autowired
    QinCeDataTaskService qinCeDataTaskService;


    /**
     * t-1更新的组织架构/部门数据
     */
    @XxlJob("qince_department_task")
    public void departmentSyncTask(){
        log.info("[xxl-job] start === 同步昨日修改过的勤策部门数据");
        qinCeDataTaskService.departmentSyncTask();
        log.info("[xxl-job] end === 同步昨日修改过的勤策部门数据");

        log.info("[xxl-job] start === 更新经销商所属战区、大区信息");
        qinCeDataTaskService.putDealersOrg();
        log.info("[xxl-job] end === 更新经销商所属战区、大区信息");
    }

    /**
     * t-1更新的员工数据
     */
    @XxlJob("qince_employee_task")
    public void employeeSyncTask(){
        log.info("[xxl-job] start === 同步昨日修改过的员工数据");
        qinCeDataTaskService.employeeSyncTask(-1);
        log.info("[xxl-job] end === 同步昨日修改过的员工修改数据");
    }

    /**
     * t更新的员工数据
     */
    @XxlJob("qince_employee_task_today")
    public void employeeSyncTaskToday(){
        log.info("[xxl-job] start === 同步今日修改过的员工数据");
        qinCeDataTaskService.employeeSyncTask(0);
        log.info("[xxl-job] end === 同步今日修改过的员工修改数据");
    }

    /**
     * 1小时内修改过的终端数据
     */
    @XxlJob("qince_shop_task")
    public void shopDetailAllTask(){
        log.info("[xxl-job] start === 同步1小时内终端数据");
        qinCeDataTaskService.shopDetailAllTask();
        log.info("[xxl-job] end === 同步近1小时内终端数据");
    }

    /**
     * 同步[商品类型]
     * 全量
     * 0 12 2
     */
    @XxlJob("qince_product_type_task")
    public void productTypeAllTask(){
        log.info("[xxl-job] start === 同步商品类型");
        qinCeDataTaskService.productQueryPdTypeAllTask();
        log.info("[xxl-job] end === 同步商品类型");
    }

    /**
     * 同步[商品详情]
     * 0 10 2
     * 全量
     */
    @XxlJob("qince_product_info_task")
    public void productInfoAllTask(){
        log.info("[xxl-job] start === 同步商品详情");
        qinCeDataTaskService.productAllTask();
        log.info("[xxl-job] end === 同步商品详情");
    }

    /**
     * 同步[经销商列表]
     * t-1更新的经销商
     */
    @XxlJob("qince_dealers")
    public void dealersTask(){
        log.info("[xxl-job] start === 同步昨日经销商");
        qinCeDataTaskService.productDealers();
        log.info("[xxl-job] end === 同步昨日经销商");
    }

}
