package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-20 17
 * @describe :今日活动 - （出售列表中添加）出售单元
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityMarketCellVo {
    /**
     * 促销员id
     * temporaryInfo表id
     */
    private Integer temporaryId;

    /**
     * market_cell 表id
     * 影响保存逻辑：有则修改，无则新增
     */
    private Long marketCellId;

    /**
     * 保存到redis中的 uuid
     * 未保存到数据且保存到redis中的数据：根据这个id进行缓存数据的修改
     */
    private String uuid;


    /**
     * 类型名称
     */
    private String prdClassName;

    /**
     * 商品品类名称
     */
    private String prdName;


    /**
     * 商品品类编码
     */
    private String prdId;

    /**
     * 卖出数据 - 袋
     */
    private Integer bag;

    /**
     * 卖出数据 - 箱
     */
    private Integer box;

    public void saveDataVerify() {
//        if (Objects.isNull(this.marketCellId) && StringUtils.isBlank(this.uuid)){
//            throw new ParamException(RCode.DATA_NOT_HAVE_ERROR, null);
//        }

        if (StringUtils.isBlank(this.prdClassName) || StringUtils.isBlank(this.prdId)){
            throw new ParamException(RCode.PRODUCT_CLASS_NOT_ERROR, null);
        }

        if ((Objects.isNull(this.bag) && Objects.isNull(this.box)) || (this.bag + this.box <= 0)) {
            throw new ParamException(RCode.MARKET_NUMBER_NOT_ERROR, null);
        }

    }


}
