package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.PromotionStoreVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.PromotionStoreQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-18 15
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/activity/promotion/store/query")
public class PromotionStoreQueryController {

    @Autowired
    PromotionStoreQueryService promotionStoreQueryService;

    /**
     * 查询店铺列表：目前不分页
     */
    @PostMapping("/list")
    public R findStoreList(@RequestBody PromotionStoreVo promotionStoreVo){
        List<PromotionStoreDto> storeDtos = promotionStoreQueryService.findStoreList(promotionStoreVo);
        return R.success(storeDtos);
    }
}
