package com.wangxiaolu.promotion.controller.activity.temporary;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.PromotionStoreCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-06-18 13
 * @describe : 店铺操作
 */
@Slf4j
@RestController
@RequestMapping("/activity/promotion/store/core")
public class PromotionStoreCoreController {

    @Autowired
    PromotionStoreCoreService promotionStoreCoreService;
    @Autowired
    RedisCache redisCache;

    @PostMapping("/save")
    public R saveStore(@RequestHeader("Authorization") String authorization, @RequestBody PromotionStoreDto promotionStoreDto) {
        // 在缓存中查询
        JSONObject userJson = redisCache.getToJson(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + authorization);

        promotionStoreDto.setTemporaryId(userJson.getInteger("id"));
        promotionStoreDto.setTemporaryName(userJson.getString("name"));
        promotionStoreDto.setDeptQcId(userJson.getString("deptQcId"));
        promotionStoreDto.setDeptQcOrgName(userJson.getString("deptQcOrgName"));
        promotionStoreDto.setChargerQcId(userJson.getString("chargerQcId"));
        promotionStoreDto.setChargerName(userJson.getString("chargerName"));


        promotionStoreCoreService.saveStore(promotionStoreDto);
        return R.success();
    }
}
