package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.user.dao.QinceProductInfoDao;
import com.wangxiaolu.promotion.domain.user.dao.QinceProductTypeDao;
import com.wangxiaolu.promotion.pojo.CascadeVo;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductInfoDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductTypeDto;
import com.wangxiaolu.promotion.service.user.QinCeProductQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-06-19 17
 * @describe :
 */
@Slf4j
@Service
public class QinCeProductQueryServiceImpl implements QinCeProductQueryService {

    @Autowired
    QinceProductTypeDao qinceProductTypeDao;
    @Autowired
    QinceProductInfoDao qinceProductInfoDao;

    @Override
    public List<QinceProductTypeDto> findProductTypeList() {
        return qinceProductTypeDao.findAll();
    }

    @Override
    public List<CascadeVo> findProductCascade() {
        List<QinceProductInfoDto> qinceProductInfoDtos = qinceProductInfoDao.selectList();

        Map<String, List<CascadeVo>> casadeMap = new HashMap<>();
        // 组装商品
        for (QinceProductInfoDto infoDto : qinceProductInfoDtos) {
            String className = infoDto.getClassName();

            List<CascadeVo> cascades = null;
            if (casadeMap.containsKey(className)) {
                cascades = casadeMap.get(className);
            } else {
                cascades = new ArrayList<>();
            }
            cascades.add(new CascadeVo(infoDto.getPrdName(), infoDto.getPrdId()));
            casadeMap.put(className, cascades);
        }

        List<CascadeVo> cascades = new ArrayList<>();
        for (Map.Entry<String, List<CascadeVo>> entry : casadeMap.entrySet()) {
            cascades.add(new CascadeVo(entry.getKey(), entry.getKey(), entry.getValue()));
        }

        return cascades;
    }
}
