package com.wangxiaolu.promotion.domain.manage.wrapperQo;

import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-08-29 13
 * @describe :
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ActivityPlanInfoWrapper {

    /**
     * 活动计划表上传记录id
     */
    private Long activityPlanRecordId;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * manage_employee_info表id
     */
    private Integer employeeId;

    /**
     * 活动月份YYYY-MM
     */
    private String activityMonth;

    /**
     * 活动开始日期
     */
    private Date activityStartDate;

    /**
     * 活动结束日期
     */
    private Date activityEndDate;

    /**
     * 省
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    private String area;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 店铺名称
     */
    private String storeName;
    private String storeNameLike;
    private String qinceStoreCode;
    private String StoreCode;

    /**
     * 部门勤策编码
     */
    private String orgQcId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 活动状态
     */
    private  StatusType activityStatus;

    /**
     * 活动计划状态
     * 是否执行：1:执行；0：未执行；
     */
    private PlanStatus planStatus;

    private List<Long> ids;

    private Long id;

    private StatusType activityStatusUpdate;
    private StatusType isDeleteUpdate;
    /**
     * 活动模式
     */
    private Integer activityPatternId;
    private String activityPattern;

    private Date activityDate;

    private Integer limitNum;

    public Date getActivityEndDate() {
        String format = DateUtil.format(this.activityEndDate, "yyyy-MM-dd 23:59:59");
        return DateUtil.parse(format);
    }
}
