package com.wangxiaolu.promotion.utils;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-04-15 15
 * @describe :
 */
@Slf4j
@Component
public class TencentUtils {

    /**
     * tengxunyun.sms
     */
    @Value("${tengxunyun.secret_d}")
    private String secretId;
    @Value("${tengxunyun.secret_key}")
    private String secretKey;

    /**
     * tengxunyun.sms
     */
    @Value("${tengxunyun.sms.endpoint_beijing}")
    private String endpointBeijing;
    @Value("${tengxunyun.sms.ap_beijing}")
    private String apBeijing;
    @Value("${tengxunyun.sms.sdk_app_id_defult}")
    private String sdkAppIdDefult;
    @Value("${tengxunyun.sms.sign_name_a}")
    private String signNameA;
    @Value("${tengxunyun.sms.template_id_a}")
    private String templateIdA;
    @Value("${tengxunyun.sms.overdue_long}")
    private long overdueLong;

    /**
     * 给指定手机号发送验证码
     *
     * @param phone 手机号(1个)
     */
    public boolean sendSmsPhoneVerCOde(String phone, String phoneVerCode) {
        String signName = signNameA;
        String templateId = templateIdA;

        String[] templateParamSet = {phoneVerCode, Long.toString(overdueLong)};
        String[] phoneNumberSet = {"+86" + phone};

        SendSmsResponse res = sendSms(templateParamSet, phoneNumberSet, signName, templateId);
        SendStatus sendStatus = res.getSendStatusSet()[0];
        if (StringUtils.isBlank(sendStatus.getCode()) || !sendStatus.getCode().contains("OK")) {
            return false;
        }
        return true;
    }

    /**
     * 核心工具：发送短信
     * @return 发送结果
     */
    private SendSmsResponse sendSms(String[] templateParamSet, String[] phoneNumberSet, String signName, String templateId) {
        try {
            // 必要步骤
            // 1、实例化一个认证对象
            Credential cred = new Credential(secretId, secretKey);
            // 2、实例化http选项，SDK默认使用POST方法，GET方法无法处理一些较大的请求（非必要不使用）;SDK有默认的超时时间，非必要请不要进行调整
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("POST");
            httpProfile.setConnTimeout(60);
            httpProfile.setEndpoint(endpointBeijing);

            // 非必要步骤
            // 1、例化一个客户端配置对象
            ClientProfile clientProfile = new ClientProfile();
            /* SDK默认用TC3-HMAC-SHA256进行签名
             * 非必要请不要修改这个字段 */
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            // 实例化sms(服务)的client对象
            SmsClient client = new SmsClient(cred, apBeijing, clientProfile);
            /* 实例化一个请求对象，根据调用的接口和实际情况，可以进一步设置请求参数*/
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppId(sdkAppIdDefult);
            req.setSignName(signName);
            req.setTemplateId(templateId);

            // 参数列表：index0：验证码；index1：过期时间(分钟)
            req.setTemplateParamSet(templateParamSet);

            // 下发手机号码，采用E.164标准(+[国家或地区码][手机号])，最多不要超过200个手机号
            req.setPhoneNumberSet(phoneNumberSet);

            /* 用户的 session 内容（无需要可忽略）: 可以携带用户侧 ID 等上下文信息，server 会原样返回 */
            String sessionContext = "";
            req.setSessionContext(sessionContext);
            /* 短信码号扩展号（无需要可忽略）: 默认未开通，如需开通请联系 [腾讯云短信小助手] */
            String extendCode = "";
            req.setExtendCode(extendCode);
            /* 国内短信无需填写该项；国际/港澳台短信已申请独立 SenderId 需要填写该字段，默认使用公共 SenderId，无需填写该字段。注：月度使用量达到指定量级可申请独立 SenderId 使用，详情请联系 [腾讯云短信小助手](https://cloud.tencent.com/document/product/382/3773#.E6.8A.80.E6.9C.AF.E4.BA.A4.E6.B5.81)。*/
            String senderid = "";
            req.setSenderId(senderid);
            /* 通过 client 对象调用 SendSms 方法发起请求。注意请求方法名与请求对象是对应的
             * 返回的 res 是一个 SendSmsResponse 类的实例，与请求对象对应 */

            SendSmsResponse res = client.SendSms(req);

            // 输出json格式的字符串回包，或者取出单个值：System.out.println(res.getRequestId());
            log.info("腾讯云-短信发送结果：{}", SendSmsResponse.toJsonString(res));
            return res;
        } catch (TencentCloudSDKException e) {
            log.error("腾讯云-短信服务，SMS发送异常：{}", e.getMessage());
            throw new ParamException(RCode.TENCENT_SMS_ERROR, null);
        }
    }

}
