package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.wangxiaolu.promotion.common.enums.FlagType;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityTaskClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityTaskClockDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityTaskWrapperDto;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.enums.activity.ActivityClockTaskStatus;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.res.TemporaryActivityTaskClockRes;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityTaskClockReq;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import com.wangxiaolu.promotion.utils.AuthUtils;
import com.wangxiaolu.promotion.utils.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

@Service
public class TemporaryActivityTaskClockServiceImpl extends ServiceImpl<TemporaryActivityTaskClockMapper, TemporaryActivityTaskClockDO> implements TemporaryActivityTaskClockService {

    @Resource
    private TemporaryActivityTaskClockDao temporaryActivityTaskClockDao;
    @Resource
    private TemporaryActivityPhotoDao photoDao;
    @Resource
    private TemporaryActivityClockQueryService clockQueryService;

    @Override
    public List<TemporaryActivityTaskClockDO> listByTemporaryId(Long temporaryId) {
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setTemporaryId(temporaryId)
                .setIsDelete(FlagType.NO.getType());
        // 过滤未删除数据
        return temporaryActivityTaskClockDao.selectList(wrapper);
    }

    /**
     * 生成随机打卡任务
     *
     * @param dto
     */
    @Override
    public void generateRandomClockTask(TemporaryClockDto dto) {
        // 查询是否已有数据
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto();
        wrapper.setTemporaryId(dto.getTemporaryId())
                .setClockId(dto.getId())
                .setTaskType(ActivityPhotoType.RANDOM_TASK.getType())
                .setCreateDate(DateUtil.today())
                .setIsDelete(FlagType.NO.getType());
        TemporaryActivityTaskClockDO taskClockDO1 = temporaryActivityTaskClockDao.selectOne(wrapper);
        if (ObjectUtil.isNotEmpty(taskClockDO1)) {
            return;
        }

        // 随机生成 下午5:30～7:30 之间的Date
        LocalTime randomTime = LocalTime.of(17, 30, 0).plusMinutes(ThreadLocalRandom.current().nextInt(0, 120));

        Date randomDate = DateUtils.parseDateByLocalTime(randomTime);
        // 生成
        TemporaryActivityTaskClockDO taskClockDO = new TemporaryActivityTaskClockDO();
        taskClockDO.setClockId(dto.getId())
                .setTemporaryId(dto.getTemporaryId())
                .setTemporaryName(dto.getTemporaryName())
                .setReportedId(dto.getReportedId())
                .setPlanId(dto.getPlanId())
                .setClockTime(null)
                .setTaskType(ActivityPhotoType.RANDOM_TASK.getType())
                .setTaskStatus(ActivityClockTaskStatus.TO_BE_START.getType())
                .setRequiredlockTime(randomDate)
                .setActivityPatternId(dto.getActivityPatternId())
                .setActivityPattern(dto.getActivityPattern())
                .setCreateDate(DateUtil.today())
                .setIsDelete(FlagType.NO.getType());
        temporaryActivityTaskClockDao.save(taskClockDO);

    }

    /**
     * 生成POS数据上传任务
     *
     * @param dto
     */

    @Override
    public void generatePosUploadTask(TemporaryClockDto dto) {
        // 查询是否已有数据
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto();
        wrapper.setTemporaryId(dto.getTemporaryId())
                .setClockId(dto.getId())
                .setReportId(dto.getReportedId())
                .setCreateDate(DateUtil.today())
                .setTaskType(ActivityPhotoType.POS_PHOTO.getType())
                .setIsDelete(FlagType.NO.getType());
        TemporaryActivityTaskClockDO taskClockDO1 = temporaryActivityTaskClockDao.selectOne(wrapper);
        if (ObjectUtil.isNotEmpty(taskClockDO1)) {
            return;
        }
        // 生成
        TemporaryActivityTaskClockDO taskClockDO = new TemporaryActivityTaskClockDO();
        taskClockDO.setClockId(dto.getId())
                .setTemporaryId(dto.getTemporaryId())
                .setTemporaryName(dto.getTemporaryName())
                .setReportedId(dto.getReportedId())
                .setPlanId(dto.getPlanId())
                .setClockTime(null)
                .setTaskType(ActivityPhotoType.POS_PHOTO.getType())
                .setTaskStatus(ActivityClockTaskStatus.STARTING.getType())
                .setRequiredlockTime(null)
                .setActivityPatternId(dto.getActivityPatternId())
                .setActivityPattern(dto.getActivityPattern())
                .setCreateDate(DateUtil.today())
                .setIsDelete(FlagType.NO.getType());
        temporaryActivityTaskClockDao.save(taskClockDO);
    }

    @Override
    public List<TemporaryActivityTaskClockDO> listByUserId() {
        // 从header获取token标识
        String token = AuthUtils.getToken();
        String userId = AuthUtils.getUserId(token);
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setUserId(Long.parseLong(userId))
                .setClockId(null)
                .setTemporaryId(Long.parseLong(userId))
                .setIsDelete(FlagType.NO.getType());
        List<TemporaryActivityTaskClockDO> list = temporaryActivityTaskClockDao.selectList(wrapper);
        return list;
    }

    /**
     * 打卡打卡
     *
     * @param clockVo
     */
    @Override
    public void taskClock(TemporaryActivityTaskClockReq clockVo) {
        TemporaryActivityTaskClockDO taskClockDO = temporaryActivityTaskClockDao.selectById(clockVo.getId());
        if (taskClockDO == null) {
            throw new IllegalArgumentException("打卡任务不存在");
        }
        // 随机打卡
        if (ActivityPhotoType.RANDOM_TASK.getType() == clockVo.getTaskType()) {
            // 检查当前时间是否在打卡要求的时间内
            Date requiredLockTime = taskClockDO.getRequiredlockTime();
            // 计算15分钟以后得时间
            Date latestRequiredLockTime = DateUtil.offsetMinute(requiredLockTime, 15).toJdkDate();
            if (new Date().compareTo(requiredLockTime) < 0 || new Date().compareTo(latestRequiredLockTime) > 0) {
                throw new IllegalArgumentException("当前时间不在打卡要求的时间内");
            }
        }
        BeanUtils.copyProperties(clockVo, taskClockDO);
        // 更新 任务状态为未完成，打卡时间为当前时间
        taskClockDO.setTaskStatus(ActivityClockTaskStatus.COMPLETED.getType());
        taskClockDO.setClockTime(new Date());

        temporaryActivityTaskClockDao.update(taskClockDO);


        TemporaryClockWrapper wr = new TemporaryClockWrapper();
        wr.setId(taskClockDO.getClockId());

        TemporaryClockDto clockDto = clockQueryService.findClockInfo(wr);
        TemporaryActivityPhotoDto dto = new TemporaryActivityPhotoDto();
        dto.setClockId(taskClockDO.getClockId())
                .setTemporaryId(taskClockDO.getTemporaryId())
                // reportedId 问题
                .setReportedId(clockDto.getReportedId())
                .setClockId(taskClockDO.getClockId())
                .setType(clockVo.getTaskType());
        if (CollectionUtils.isEmpty(clockVo.getClockPhotos())) {
            photoDao.deleteListByClockId(taskClockDO.getClockId(), clockVo.getTaskType());
        } else {
            // 保存打卡图片
            photoDao.saveClockTaskPhoto(dto, clockVo.getClockPhotos());
        }

    }

    @Override
    public TemporaryActivityTaskClockRes queryByMyTaskType(Integer taskType) {
        // 从header获取token标识
        String token = AuthUtils.getToken();
        String userId = AuthUtils.getUserId(token);
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setUserId(Long.parseLong(userId))
                .setTaskType(taskType)
                .setCreateDate(DateUtil.today())
                .setTemporaryId(Long.parseLong(userId))
                .setIsDelete(FlagType.NO.getType());
        TemporaryActivityTaskClockDO taskClockDO = temporaryActivityTaskClockDao.selectOne(wrapper);
        if (taskClockDO != null) {
            TemporaryActivityTaskClockRes res = new TemporaryActivityTaskClockRes();
            BeanUtils.copyProperties(taskClockDO, res);
            // 查询图片
            TemporaryPhotoWrapper photoWrapper = new TemporaryPhotoWrapper()
                    .setClockId(taskClockDO.getClockId())
                    .setTemporaryId(taskClockDO.getTemporaryId());
            List<TemporaryActivityPhotoDto> photoDtos = photoDao.selectPhotos(photoWrapper);
            List<String> photoUrls = photoDtos.stream()
                    .filter(photoDto -> photoDto.getType().equals(taskType))
                    .map(TemporaryActivityPhotoDto::getPhotoUrl)
                    .collect(Collectors.toList());
            res.setClockPhotos(photoUrls);
            return res;
        }
        return null;
    }


}
