package com.wangxiaolu.promotion.service.activity.examine.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.examine.dao.ActivityExamineDao;
import com.wangxiaolu.promotion.domain.examine.wrapperQo.ExamineWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2025-04-02 14
 * @describe :
 */
@Service
public class ExaPlanQueryServiceImpl implements ExaPlanQueryService {

    @Autowired
    private ActivityExamineDao activityExamineDao;

    @Override
    public ActivityExamineDto selectById(Long id) {
        return activityExamineDao.selectById(id);
    }

    @Override
    public ActivityExamineDto selectByPlanId(Long planId) {
        return activityExamineDao.selectByPlanId(planId);
    }

    @Override
    public void page(PageInfo pageInfo) {
        ExamineWrapper wq = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), ExamineWrapper.class);
        activityExamineDao.page(pageInfo,wq);
    }

}
