package com.wangxiaolu.promotion.domain.activity.dao;

import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
public interface TemporaryActivityClockDao {
    /**
     * 保存打卡信息
     * @param dto 信息
     */
    void save(TemporaryClockDto dto);

    /**
     * 修改打卡信息
     * @param dto 信息
     */
    void updateById(TemporaryClockDto dto);

    /**
     * @param tcw 查询条件
     * @return 上述条件只能满足一条记录
     */
    TemporaryClockDto selectOne(TemporaryClockWrapper tcw);

    List<TemporaryClockDto> selectList(TemporaryClockWrapper tcw);


    TemporaryClockDto selectById(Long id);

    /**
     * 员工查询负责的促销员打卡信息（分页查询）
     */
    void employeePage(String employeeQcId, PageInfo pageInfo,TemporaryClockWrapper tcw);

    TemporaryClockDto findLatestClockByTemporaryId( Long temporaryId);

    TemporaryClockDto findClockInfo(TemporaryClockWrapper wr);

}
