package com.wangxiaolu.promotion.controller.activity.employee;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeQueryTemClockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-05-29 14
 * @describe : 员工查询促销员活动上报信息
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/query")
public class EmployeeQueryTemClockController {

    @Autowired
    EmployeeQueryTemClockService employeeQueryTemClockService;

    /**
     * 查询员工打卡记录
     */
    @PostMapping("/clock/page")
    public R findClockList(@RequestHeader("loginQcId") String loginQcId, @RequestBody PageInfo pageInfo) {
        employeeQueryTemClockService.findClockList(loginQcId, pageInfo);
        return R.success(pageInfo);
    }


}
