package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityPlanVo;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-09-03 11
 * @describe :
 */
@Service
public class ActivityPlanInfoQueryServiceImpl implements ActivityPlanInfoQueryService {
    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;

    @Override
    public void findActivityPlanInfoPage(PageInfo pageInfo) {
        ActivityPlanInfoWrapper wrapper = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), ActivityPlanInfoWrapper.class);
        employeeActivityPlanInfoDao.page(pageInfo,wrapper);
    }

    @Override
    public EmployeeActivityPlanInfoDto findActivityPlanInfoOne(ActivityPlanInfoVo activityPlanInfoVo) {
        ActivityPlanInfoWrapper wrapper = new ActivityPlanInfoWrapper();
        BeanUtils.copyProperties(activityPlanInfoVo,wrapper);
        return employeeActivityPlanInfoDao.selectOne(wrapper);
    }
}
