package com.wangxiaolu.promotion.utils;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONObject;
import com.wangxiaolu.promotion.common.constant.Constants;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

@Component
@Slf4j
public class WechatAccessTokenUtil {
    @Value("${wx.cx_miniapp.app_id}")
    private String appid;
    @Value("${wx.cx_miniapp.app_secret}")
    private String secret;
    private static final String TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";

    // 缓存access_token，避免频繁调用
    private String accessToken;
    private long expireTime;
    @Resource
    private WxMaService wxMaService ;


    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private RedisCache redisCache;



    // 获取有效的access_token
    public String getAccessToken() {
        String accessTokenRedisCache = redisCache.get(Constants.REDIS_ACCESS_TOKEN);
        // 检查是否过期，未过期直接返回
        if (ObjectUtil.isNotEmpty(accessTokenRedisCache)) {
            return accessToken;
        }
        // 过期则重新获取
        String url = String.format(TOKEN_URL, appid, secret);
        String response = restTemplate.getForObject(url, String.class);

        // string 转json
        JSONObject json = JSONObject.parseObject( response) ;
        accessToken = json.getString("access_token");
        // 有效期（秒）
        int expiresIn = json.getIntValue("expires_in");
        // 提前5分钟过期
        expireTime = System.currentTimeMillis() + (expiresIn - 300) * 1000;
        log.info("获取微信access_token,url:{},response:{}",url,response);

        redisCache.addToSeconds(Constants.REDIS_ACCESS_TOKEN,accessToken,expiresIn - 300);
        return accessToken;

    }
}
