package com.wangxiaolu.promotion.controller.wechat;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryLoginVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import com.wangxiaolu.promotion.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 13
 * @describe :微信用户信息查询
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/query")
public class WeChatUserQueryController {

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;

    /**
     * 根据OpenId、Phone登录（促销员查询是否存在）
     * @return  非null则登录成功
     */
    @PostMapping("/temporary/login/phone_openid")
    public WxTemporaryInfoDto temporaryLoginByPhoneAndOpenId(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        if (!DataUtils.phonePattern(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        WxTemporaryInfoDto wxTemDto = weChatUserQueryService.loginTemporaryByOpenIdAndPhone(wxTemporaryLoginVo.getOpenId(), wxTemporaryLoginVo.getPhone());
        if (Objects.isNull(wxTemDto)){
            throw new ParamException(RCode.LOGIN_USER_IS_NULL_ERROR, null);
        }
        return wxTemDto;
    }


    /**
     * 需要改成：根据token查询人员详情
     * 促销员查询
     */
    @GetMapping("/temporary/openId")
    public WxTemporaryInfoDto getTemporaryInfoByOpenId(String openId) {

        return weChatUserQueryService.getTemporaryByToken(openId);
    }
}
