package com.wangxiaolu.promotion.config.aspet;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@Component
@Aspect
public class ControllerLogAspect {

    /**
     * 对controller包中的所有类中的所有public类进行增强
     */
    @Pointcut("execution(public * com.wangxiaolu.promotion.controller..*.*(..))")
    private void pointcut(){}

    @Before("pointcut()")
    public void before(JoinPoint joinPoint){
        /**
         * 此次请求
         */
        ServletRequestAttributes sra = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();

        HttpServletRequest request = sra.getRequest();

        /**
         * 暂时使用这个判断是否登录
         */
        String accessToken = request.getHeader("access_token");


//        Signature signature = joinPoint.getSignature();
//        String name = signature.getName();

        log.info("------------- 开始 -------------");
        log.info("请求地址：{}：{}", request.getMethod(), request.getRequestURL().toString());
//        log.info("类路径：{}；方法名：{}", signature.getDeclaringTypeName(), name);

        Object[] args = joinPoint.getArgs();
        Object[] arguments = new Object[args.length];
        for (int i = 0; i < args.length; i++) {
            if (args[i] instanceof ServletRequest
                    || args[i] instanceof ServletResponse
                    || args[i] instanceof MultipartFile) {
                continue;
            }
            arguments[i] = args[i];
        }

        String[] excludeProperties = {"password", "file"};
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludeFilter = filters.addFilter();
        excludeFilter.addExcludes(excludeProperties);
        log.info("请求参数: {}", JSONObject.toJSONString(arguments, excludeFilter));
    }

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long millis = System.currentTimeMillis();
        Object result = proceedingJoinPoint.proceed();

        String[] excludeProperties = {"password", "file"};
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludeFilter = filters.addFilter();
        excludeFilter.addExcludes(excludeProperties);
        log.info("返回结果: {}", JSONObject.toJSONString(result, excludeFilter));
        log.info("------------- 结束 耗时：{} ms -------------", System.currentTimeMillis() - millis);
        return result;
    }
}
